/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.SimpleExpression;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Projections {
    private Projections() {
    }

    public static <TExpression> Bson computed(String string, TExpression TExpression) {
        return new SimpleExpression<TExpression>(string, TExpression);
    }

    public static Bson computedSearchMeta(String string) {
        return Projections.computed(string, "$$SEARCH_META");
    }

    public static Bson include(String ... stringArray) {
        return Projections.include(Arrays.asList(stringArray));
    }

    public static Bson include(List<String> list) {
        return Projections.combine(list, new BsonInt32(1));
    }

    public static Bson exclude(String ... stringArray) {
        return Projections.exclude(Arrays.asList(stringArray));
    }

    public static Bson exclude(List<String> list) {
        return Projections.combine(list, new BsonInt32(0));
    }

    public static Bson excludeId() {
        return new BsonDocument("_id", new BsonInt32(0));
    }

    public static Bson elemMatch(String string) {
        return new BsonDocument(string + ".$", new BsonInt32(1));
    }

    public static Bson elemMatch(String string, Bson bson) {
        return new ElemMatchFilterProjection(string, bson);
    }

    public static Bson meta(String string, String string2) {
        return new BsonDocument(string, new BsonDocument("$meta", new BsonString(string2)));
    }

    public static Bson metaTextScore(String string) {
        return Projections.meta(string, "textScore");
    }

    public static Bson metaSearchScore(String string) {
        return Projections.meta(string, "searchScore");
    }

    public static Bson metaVectorSearchScore(String string) {
        return Projections.meta(string, "vectorSearchScore");
    }

    public static Bson metaSearchHighlights(String string) {
        return Projections.meta(string, "searchHighlights");
    }

    public static Bson slice(String string, int n) {
        return new BsonDocument(string, new BsonDocument("$slice", new BsonInt32(n)));
    }

    public static Bson slice(String string, int n, int n2) {
        return new BsonDocument(string, new BsonDocument("$slice", new BsonArray(Arrays.asList(new BsonInt32(n), new BsonInt32(n2)))));
    }

    public static Bson fields(Bson ... bsonArray) {
        return Projections.fields(Arrays.asList(bsonArray));
    }

    public static Bson fields(List<? extends Bson> list) {
        Assertions.notNull("projections", list);
        return new FieldsProjection(list);
    }

    private static Bson combine(List<String> list, BsonValue bsonValue) {
        BsonDocument bsonDocument = new BsonDocument();
        for (String string : list) {
            bsonDocument.remove(string);
            bsonDocument.append(string, bsonValue);
        }
        return bsonDocument;
    }

    private static class ElemMatchFilterProjection
    implements Bson {
        private final String fieldName;
        private final Bson filter;

        ElemMatchFilterProjection(String string, Bson bson) {
            this.fieldName = string;
            this.filter = bson;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            return new BsonDocument(this.fieldName, new BsonDocument("$elemMatch", this.filter.toBsonDocument(clazz, codecRegistry)));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ElemMatchFilterProjection elemMatchFilterProjection = (ElemMatchFilterProjection)object;
            if (!Objects.equals(this.fieldName, elemMatchFilterProjection.fieldName)) {
                return false;
            }
            return Objects.equals(this.filter, elemMatchFilterProjection.filter);
        }

        public int hashCode() {
            int n = this.fieldName != null ? this.fieldName.hashCode() : 0;
            n = 31 * n + (this.filter != null ? this.filter.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "ElemMatch Projection{fieldName='" + this.fieldName + '\'' + ", filter=" + this.filter + '}';
        }
    }

    private static class FieldsProjection
    implements Bson {
        private final List<? extends Bson> projections;

        FieldsProjection(List<? extends Bson> list) {
            this.projections = list;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocument bsonDocument = new BsonDocument();
            for (Bson bson : this.projections) {
                BsonDocument bsonDocument2 = bson.toBsonDocument(clazz, codecRegistry);
                for (String string : bsonDocument2.keySet()) {
                    bsonDocument.remove(string);
                    bsonDocument.append(string, bsonDocument2.get(string));
                }
            }
            return bsonDocument;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FieldsProjection fieldsProjection = (FieldsProjection)object;
            return Objects.equals(this.projections, fieldsProjection.projections);
        }

        public int hashCode() {
            return this.projections != null ? this.projections.hashCode() : 0;
        }

        public String toString() {
            return "Projections{projections=" + this.projections + '}';
        }
    }
}

