/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.lang.Nullable;
import java.util.Objects;
import org.bson.conversions.Bson;

public class PushOptions {
    private Integer position;
    private Integer slice;
    private Integer sort;
    private Bson sortDocument;

    @Nullable
    public Integer getPosition() {
        return this.position;
    }

    public PushOptions position(@Nullable Integer n) {
        this.position = n;
        return this;
    }

    @Nullable
    public Integer getSlice() {
        return this.slice;
    }

    public PushOptions slice(@Nullable Integer n) {
        this.slice = n;
        return this;
    }

    @Nullable
    public Integer getSort() {
        return this.sort;
    }

    public PushOptions sort(@Nullable Integer n) {
        if (this.sortDocument != null) {
            throw new IllegalStateException("sort can not be set if sortDocument already is");
        }
        this.sort = n;
        return this;
    }

    @Nullable
    public Bson getSortDocument() {
        return this.sortDocument;
    }

    public PushOptions sortDocument(@Nullable Bson bson) {
        if (this.sort != null) {
            throw new IllegalStateException("sortDocument can not be set if sort already is");
        }
        this.sortDocument = bson;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PushOptions pushOptions = (PushOptions)object;
        if (!Objects.equals(this.position, pushOptions.position)) {
            return false;
        }
        if (!Objects.equals(this.slice, pushOptions.slice)) {
            return false;
        }
        if (!Objects.equals(this.sort, pushOptions.sort)) {
            return false;
        }
        return Objects.equals(this.sortDocument, pushOptions.sortDocument);
    }

    public int hashCode() {
        int n = this.position != null ? this.position.hashCode() : 0;
        n = 31 * n + (this.slice != null ? this.slice.hashCode() : 0);
        n = 31 * n + (this.sort != null ? this.sort.hashCode() : 0);
        n = 31 * n + (this.sortDocument != null ? this.sortDocument.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "Push Options{position=" + this.position + ", slice=" + this.slice + (this.sort == null ? "" : ", sort=" + this.sort) + (this.sortDocument == null ? "" : ", sortDocument=" + this.sortDocument) + '}';
    }
}

