/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.WriteModel;
import org.bson.conversions.Bson;

public final class ReplaceOneModel<T>
extends WriteModel<T> {
    private final Bson filter;
    private final T replacement;
    private final ReplaceOptions options;

    public ReplaceOneModel(Bson bson, T t) {
        this(bson, t, new ReplaceOptions());
    }

    public ReplaceOneModel(Bson bson, T t, ReplaceOptions replaceOptions) {
        this.filter = Assertions.notNull("filter", bson);
        this.options = Assertions.notNull("options", replaceOptions);
        this.replacement = Assertions.notNull("replacement", t);
    }

    public Bson getFilter() {
        return this.filter;
    }

    public T getReplacement() {
        return this.replacement;
    }

    public ReplaceOptions getReplaceOptions() {
        return this.options;
    }

    public String toString() {
        return "ReplaceOneModel{filter=" + this.filter + ", replacement=" + this.replacement + ", options=" + this.options + '}';
    }
}

