/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class ReplaceOptions {
    private boolean upsert;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private Bson hint;
    private String hintString;
    private BsonValue comment;
    private Bson variables;
    private Bson sort;

    public boolean isUpsert() {
        return this.upsert;
    }

    public ReplaceOptions upsert(boolean bl) {
        this.upsert = bl;
        return this;
    }

    @Nullable
    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public ReplaceOptions bypassDocumentValidation(@Nullable Boolean bl) {
        this.bypassDocumentValidation = bl;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public ReplaceOptions collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Nullable
    public Bson getHint() {
        return this.hint;
    }

    public ReplaceOptions hint(@Nullable Bson bson) {
        this.hint = bson;
        return this;
    }

    @Nullable
    public String getHintString() {
        return this.hintString;
    }

    public ReplaceOptions hintString(@Nullable String string) {
        this.hintString = string;
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public ReplaceOptions comment(@Nullable String string) {
        this.comment = string != null ? new BsonString(string) : null;
        return this;
    }

    public ReplaceOptions comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    @Nullable
    public Bson getLet() {
        return this.variables;
    }

    public ReplaceOptions let(Bson bson) {
        this.variables = bson;
        return this;
    }

    @Nullable
    public Bson getSort() {
        return this.sort;
    }

    public ReplaceOptions sort(@Nullable Bson bson) {
        this.sort = bson;
        return this;
    }

    public String toString() {
        return "ReplaceOptions{upsert=" + this.upsert + ", bypassDocumentValidation=" + this.bypassDocumentValidation + ", collation=" + this.collation + ", hint=" + this.hint + ", hintString=" + this.hintString + ", comment=" + this.comment + ", let=" + this.variables + ", sort=" + this.sort + '}';
    }
}

