/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.SearchIndexType;
import com.mongodb.lang.Nullable;
import org.bson.conversions.Bson;

public final class SearchIndexModel {
    @Nullable
    private final String name;
    private final Bson definition;
    @Nullable
    private final SearchIndexType type;

    public SearchIndexModel(Bson bson) {
        this(null, bson, null);
    }

    public SearchIndexModel(String string, Bson bson) {
        this(string, bson, null);
    }

    public SearchIndexModel(@Nullable String string, Bson bson, @Nullable SearchIndexType searchIndexType) {
        this.definition = Assertions.notNull("definition", bson);
        this.name = string;
        this.type = searchIndexType;
    }

    public Bson getDefinition() {
        return this.definition;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public SearchIndexType getType() {
        return this.type;
    }

    public String toString() {
        return "SearchIndexModel{name=" + this.name + ", definition=" + this.definition + ", type=" + (this.type == null ? "null" : this.type.toBsonValue()) + '}';
    }
}

