/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.BuildersHelper;
import java.util.Objects;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class SimpleExpression<TExpression>
implements Bson {
    private final String name;
    private final TExpression expression;

    SimpleExpression(String string, TExpression TExpression) {
        this.name = string;
        this.expression = TExpression;
    }

    @Override
    public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
        BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
        bsonDocumentWriter.writeStartDocument();
        bsonDocumentWriter.writeName(this.name);
        BuildersHelper.encodeValue(bsonDocumentWriter, this.expression, codecRegistry);
        bsonDocumentWriter.writeEndDocument();
        return bsonDocumentWriter.getDocument();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SimpleExpression simpleExpression = (SimpleExpression)object;
        if (!Objects.equals(this.name, simpleExpression.name)) {
            return false;
        }
        return Objects.equals(this.expression, simpleExpression.expression);
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n = 31 * n + (this.expression != null ? this.expression.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "Expression{name='" + this.name + '\'' + ", expression=" + this.expression + '}';
    }
}

