/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Sorts {
    private Sorts() {
    }

    public static Bson ascending(String ... stringArray) {
        return Sorts.ascending(Arrays.asList(stringArray));
    }

    public static Bson ascending(List<String> list) {
        Assertions.notNull("fieldNames", list);
        return Sorts.orderBy(list, new BsonInt32(1));
    }

    public static Bson descending(String ... stringArray) {
        return Sorts.descending(Arrays.asList(stringArray));
    }

    public static Bson descending(List<String> list) {
        Assertions.notNull("fieldNames", list);
        return Sorts.orderBy(list, new BsonInt32(-1));
    }

    public static Bson metaTextScore(String string) {
        return new BsonDocument(string, new BsonDocument("$meta", new BsonString("textScore")));
    }

    public static Bson orderBy(Bson ... bsonArray) {
        return Sorts.orderBy(Arrays.asList(bsonArray));
    }

    public static Bson orderBy(List<? extends Bson> list) {
        Assertions.notNull("sorts", list);
        return new CompoundSort(list);
    }

    private static Bson orderBy(List<String> list, BsonValue bsonValue) {
        BsonDocument bsonDocument = new BsonDocument();
        for (String string : list) {
            bsonDocument.append(string, bsonValue);
        }
        return bsonDocument;
    }

    private static final class CompoundSort
    implements Bson {
        private final List<? extends Bson> sorts;

        private CompoundSort(List<? extends Bson> list) {
            this.sorts = list;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocument bsonDocument = new BsonDocument();
            for (Bson bson : this.sorts) {
                BsonDocument bsonDocument2 = bson.toBsonDocument(clazz, codecRegistry);
                for (String string : bsonDocument2.keySet()) {
                    bsonDocument.append(string, bsonDocument2.get(string));
                }
            }
            return bsonDocument;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CompoundSort compoundSort = (CompoundSort)object;
            return Objects.equals(this.sorts, compoundSort.sorts);
        }

        public int hashCode() {
            return this.sorts != null ? this.sorts.hashCode() : 0;
        }

        public String toString() {
            return "Compound Sort{sorts=" + this.sorts + '}';
        }
    }
}

