/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.TimeSeriesGranularity;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public final class TimeSeriesOptions {
    private final String timeField;
    private String metaField;
    private TimeSeriesGranularity granularity;
    private Long bucketMaxSpanSeconds;
    private Long bucketRoundingSeconds;

    public TimeSeriesOptions(String string) {
        this.timeField = Assertions.notNull("timeField", string);
    }

    public String getTimeField() {
        return this.timeField;
    }

    @Nullable
    public String getMetaField() {
        return this.metaField;
    }

    public TimeSeriesOptions metaField(@Nullable String string) {
        this.metaField = string;
        return this;
    }

    @Nullable
    public TimeSeriesGranularity getGranularity() {
        return this.granularity;
    }

    public TimeSeriesOptions granularity(@Nullable TimeSeriesGranularity timeSeriesGranularity) {
        Assertions.isTrue("granularity is not allowed when bucketMaxSpan is set", this.bucketMaxSpanSeconds == null);
        Assertions.isTrue("granularity is not allowed when bucketRounding is set", this.bucketRoundingSeconds == null);
        this.granularity = timeSeriesGranularity;
        return this;
    }

    @Nullable
    public Long getBucketMaxSpan(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (this.bucketMaxSpanSeconds == null) {
            return null;
        }
        return timeUnit.convert(this.bucketMaxSpanSeconds, TimeUnit.SECONDS);
    }

    public TimeSeriesOptions bucketMaxSpan(@Nullable Long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (l == null) {
            this.bucketMaxSpanSeconds = null;
        } else {
            Assertions.isTrue("bucketMaxSpan is not allowed when granularity is set", this.granularity == null);
            long l2 = TimeUnit.SECONDS.convert(l, timeUnit);
            Assertions.isTrueArgument("bucketMaxSpan, after conversion to seconds, must be >= 1", l2 > 0L);
            this.bucketMaxSpanSeconds = l2;
        }
        return this;
    }

    @Nullable
    public Long getBucketRounding(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (this.bucketRoundingSeconds == null) {
            return null;
        }
        return timeUnit.convert(this.bucketRoundingSeconds, TimeUnit.SECONDS);
    }

    public TimeSeriesOptions bucketRounding(@Nullable Long l, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (l == null) {
            this.bucketRoundingSeconds = null;
        } else {
            Assertions.isTrue("bucketRounding is not allowed when granularity is set", this.granularity == null);
            long l2 = TimeUnit.SECONDS.convert(l, timeUnit);
            Assertions.isTrueArgument("bucketRounding, after conversion to seconds, must be >= 1", l2 > 0L);
            this.bucketRoundingSeconds = l2;
        }
        return this;
    }

    public String toString() {
        return "TimeSeriesOptions{timeField='" + this.timeField + '\'' + ", metaField='" + this.metaField + '\'' + ", granularity=" + (Object)((Object)this.granularity) + ", bucketMaxSpanSeconds=" + this.bucketMaxSpanSeconds + ", bucketRoundingSeconds=" + this.bucketRoundingSeconds + '}';
    }
}

