/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.conversions.Bson;

public final class UpdateManyModel<T>
extends WriteModel<T> {
    private final Bson filter;
    private final Bson update;
    private final List<? extends Bson> updatePipeline;
    private final UpdateOptions options;

    public UpdateManyModel(Bson bson, Bson bson2) {
        this(bson, bson2, new UpdateOptions());
    }

    public UpdateManyModel(Bson bson, Bson bson2, UpdateOptions updateOptions) {
        this.filter = Assertions.notNull("filter", bson);
        this.update = Assertions.notNull("update", bson2);
        this.updatePipeline = null;
        this.options = Assertions.notNull("options", updateOptions);
    }

    public UpdateManyModel(Bson bson, List<? extends Bson> list) {
        this(bson, list, new UpdateOptions());
    }

    public UpdateManyModel(Bson bson, List<? extends Bson> list, UpdateOptions updateOptions) {
        this.filter = Assertions.notNull("filter", bson);
        this.update = null;
        this.updatePipeline = list;
        this.options = Assertions.notNull("options", updateOptions);
    }

    public Bson getFilter() {
        return this.filter;
    }

    @Nullable
    public Bson getUpdate() {
        return this.update;
    }

    @Nullable
    public List<? extends Bson> getUpdatePipeline() {
        return this.updatePipeline;
    }

    public UpdateOptions getOptions() {
        return this.options;
    }

    public String toString() {
        return "UpdateManyModel{filter=" + this.filter + ", update=" + (this.update != null ? this.update : this.updatePipeline) + ", options=" + this.options + '}';
    }
}

