/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class UpdateOptions {
    private boolean upsert;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private List<? extends Bson> arrayFilters;
    private Bson hint;
    private String hintString;
    private BsonValue comment;
    private Bson variables;
    private Bson sort;

    public boolean isUpsert() {
        return this.upsert;
    }

    public UpdateOptions upsert(boolean bl) {
        this.upsert = bl;
        return this;
    }

    @Nullable
    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public UpdateOptions bypassDocumentValidation(@Nullable Boolean bl) {
        this.bypassDocumentValidation = bl;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public UpdateOptions collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public UpdateOptions arrayFilters(@Nullable List<? extends Bson> list) {
        this.arrayFilters = list;
        return this;
    }

    @Nullable
    public List<? extends Bson> getArrayFilters() {
        return this.arrayFilters;
    }

    @Nullable
    public Bson getHint() {
        return this.hint;
    }

    public UpdateOptions hint(@Nullable Bson bson) {
        this.hint = bson;
        return this;
    }

    @Nullable
    public String getHintString() {
        return this.hintString;
    }

    public UpdateOptions hintString(@Nullable String string) {
        this.hintString = string;
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public UpdateOptions comment(@Nullable String string) {
        this.comment = string != null ? new BsonString(string) : null;
        return this;
    }

    public UpdateOptions comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    @Nullable
    public Bson getLet() {
        return this.variables;
    }

    public UpdateOptions let(Bson bson) {
        this.variables = bson;
        return this;
    }

    @Nullable
    public Bson getSort() {
        return this.sort;
    }

    public UpdateOptions sort(@Nullable Bson bson) {
        this.sort = bson;
        return this;
    }

    public String toString() {
        return "UpdateOptions{upsert=" + this.upsert + ", bypassDocumentValidation=" + this.bypassDocumentValidation + ", collation=" + this.collation + ", arrayFilters=" + this.arrayFilters + ", hint=" + this.hint + ", hintString=" + this.hintString + ", comment=" + this.comment + ", let=" + this.variables + ", sort=" + this.sort + '}';
    }
}

