/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.PushOptions;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Updates {
    public static Bson combine(Bson ... bsonArray) {
        return Updates.combine(Arrays.asList(bsonArray));
    }

    public static Bson combine(List<? extends Bson> list) {
        Assertions.notNull("updates", list);
        return new CompositeUpdate(list);
    }

    public static <TItem> Bson set(String string, @Nullable TItem TItem) {
        return new SimpleUpdate<TItem>(string, TItem, "$set");
    }

    public static Bson unset(String string) {
        return new SimpleUpdate<String>(string, "", "$unset");
    }

    public static Bson setOnInsert(Bson bson) {
        return new SimpleBsonKeyValue("$setOnInsert", bson);
    }

    public static <TItem> Bson setOnInsert(String string, @Nullable TItem TItem) {
        return new SimpleUpdate<TItem>(string, TItem, "$setOnInsert");
    }

    public static Bson rename(String string, String string2) {
        Assertions.notNull("newFieldName", string2);
        return new SimpleUpdate<String>(string, string2, "$rename");
    }

    public static Bson inc(String string, Number number) {
        Assertions.notNull("number", number);
        return new SimpleUpdate<Number>(string, number, "$inc");
    }

    public static Bson mul(String string, Number number) {
        Assertions.notNull("number", number);
        return new SimpleUpdate<Number>(string, number, "$mul");
    }

    public static <TItem> Bson min(String string, TItem TItem) {
        return new SimpleUpdate<TItem>(string, TItem, "$min");
    }

    public static <TItem> Bson max(String string, TItem TItem) {
        return new SimpleUpdate<TItem>(string, TItem, "$max");
    }

    public static Bson currentDate(String string) {
        return new SimpleUpdate<Boolean>(string, true, "$currentDate");
    }

    public static Bson currentTimestamp(String string) {
        return new SimpleUpdate<BsonDocument>(string, new BsonDocument("$type", new BsonString("timestamp")), "$currentDate");
    }

    public static <TItem> Bson addToSet(String string, @Nullable TItem TItem) {
        return new SimpleUpdate<TItem>(string, TItem, "$addToSet");
    }

    public static <TItem> Bson addEachToSet(String string, List<TItem> list) {
        return new WithEachUpdate<TItem>(string, list, "$addToSet");
    }

    public static <TItem> Bson push(String string, @Nullable TItem TItem) {
        return new SimpleUpdate<TItem>(string, TItem, "$push");
    }

    public static <TItem> Bson pushEach(String string, List<TItem> list) {
        return new PushUpdate<TItem>(string, list, new PushOptions());
    }

    public static <TItem> Bson pushEach(String string, List<TItem> list, PushOptions pushOptions) {
        return new PushUpdate<TItem>(string, list, pushOptions);
    }

    public static <TItem> Bson pull(String string, @Nullable TItem TItem) {
        return new SimpleUpdate<TItem>(string, TItem, "$pull");
    }

    public static Bson pullByFilter(final Bson bson) {
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
                BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
                bsonDocumentWriter.writeStartDocument();
                bsonDocumentWriter.writeName("$pull");
                BuildersHelper.encodeValue(bsonDocumentWriter, bson, codecRegistry);
                bsonDocumentWriter.writeEndDocument();
                return bsonDocumentWriter.getDocument();
            }
        };
    }

    public static <TItem> Bson pullAll(String string, List<TItem> list) {
        return new PullAllUpdate<TItem>(string, list);
    }

    public static Bson popFirst(String string) {
        return new SimpleUpdate<Integer>(string, -1, "$pop");
    }

    public static Bson popLast(String string) {
        return new SimpleUpdate<Integer>(string, 1, "$pop");
    }

    public static Bson bitwiseAnd(String string, int n) {
        return Updates.createBitUpdateDocument(string, "and", n);
    }

    public static Bson bitwiseAnd(String string, long l) {
        return Updates.createBitUpdateDocument(string, "and", l);
    }

    public static Bson bitwiseOr(String string, int n) {
        return Updates.createBitUpdateDocument(string, "or", n);
    }

    public static Bson bitwiseOr(String string, long l) {
        return Updates.createBitUpdateDocument(string, "or", l);
    }

    public static Bson bitwiseXor(String string, int n) {
        return Updates.createBitUpdateDocument(string, "xor", n);
    }

    public static Bson bitwiseXor(String string, long l) {
        return Updates.createBitUpdateDocument(string, "xor", l);
    }

    private static Bson createBitUpdateDocument(String string, String string2, int n) {
        return Updates.createBitUpdateDocument(string, string2, new BsonInt32(n));
    }

    private static Bson createBitUpdateDocument(String string, String string2, long l) {
        return Updates.createBitUpdateDocument(string, string2, new BsonInt64(l));
    }

    private static Bson createBitUpdateDocument(String string, String string2, BsonValue bsonValue) {
        return new BsonDocument("$bit", new BsonDocument(string, new BsonDocument(string2, bsonValue)));
    }

    private Updates() {
    }

    private static class CompositeUpdate
    implements Bson {
        private final List<? extends Bson> updates;

        CompositeUpdate(List<? extends Bson> list) {
            this.updates = list;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocument bsonDocument = new BsonDocument();
            for (Bson bson : this.updates) {
                BsonDocument bsonDocument2 = bson.toBsonDocument(clazz, codecRegistry);
                for (Map.Entry<String, BsonValue> entry : bsonDocument2.entrySet()) {
                    if (bsonDocument.containsKey(entry.getKey())) {
                        BsonDocument bsonDocument3 = (BsonDocument)entry.getValue();
                        BsonDocument bsonDocument4 = bsonDocument.getDocument(entry.getKey());
                        for (Map.Entry<String, BsonValue> entry2 : bsonDocument3.entrySet()) {
                            bsonDocument4.append(entry2.getKey(), entry2.getValue());
                        }
                        continue;
                    }
                    bsonDocument.append(entry.getKey(), entry.getValue());
                }
            }
            return bsonDocument;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CompositeUpdate compositeUpdate = (CompositeUpdate)object;
            return Objects.equals(this.updates, compositeUpdate.updates);
        }

        public int hashCode() {
            return this.updates != null ? this.updates.hashCode() : 0;
        }

        public String toString() {
            return "Updates{updates=" + this.updates + '}';
        }
    }

    private static class SimpleUpdate<TItem>
    implements Bson {
        private final String fieldName;
        private final TItem value;
        private final String operator;

        SimpleUpdate(String string, TItem TItem, String string2) {
            this.fieldName = Assertions.notNull("fieldName", string);
            this.value = TItem;
            this.operator = string2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.operator);
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.fieldName);
            BuildersHelper.encodeValue(bsonDocumentWriter, this.value, codecRegistry);
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SimpleUpdate simpleUpdate = (SimpleUpdate)object;
            if (!this.fieldName.equals(simpleUpdate.fieldName)) {
                return false;
            }
            if (!Objects.equals(this.value, simpleUpdate.value)) {
                return false;
            }
            return Objects.equals(this.operator, simpleUpdate.operator);
        }

        public int hashCode() {
            int n = this.fieldName.hashCode();
            n = 31 * n + (this.value != null ? this.value.hashCode() : 0);
            n = 31 * n + (this.operator != null ? this.operator.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "Update{fieldName='" + this.fieldName + '\'' + ", operator='" + this.operator + '\'' + ", value=" + this.value + '}';
        }
    }

    private static class SimpleBsonKeyValue
    implements Bson {
        private final String fieldName;
        private final Bson value;

        SimpleBsonKeyValue(String string, Bson bson) {
            this.fieldName = Assertions.notNull("fieldName", string);
            this.value = Assertions.notNull("value", bson);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.fieldName);
            BuildersHelper.encodeValue(bsonDocumentWriter, this.value, codecRegistry);
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SimpleBsonKeyValue simpleBsonKeyValue = (SimpleBsonKeyValue)object;
            if (!this.fieldName.equals(simpleBsonKeyValue.fieldName)) {
                return false;
            }
            return this.value.equals(simpleBsonKeyValue.value);
        }

        public int hashCode() {
            int n = this.fieldName.hashCode();
            n = 31 * n + this.value.hashCode();
            return n;
        }

        public String toString() {
            return "SimpleBsonKeyValue{fieldName='" + this.fieldName + '\'' + ", value=" + this.value + '}';
        }
    }

    private static class WithEachUpdate<TItem>
    implements Bson {
        private final String fieldName;
        private final List<TItem> values;
        private final String operator;

        WithEachUpdate(String string, List<TItem> list, String string2) {
            this.fieldName = Assertions.notNull("fieldName", string);
            this.values = Assertions.notNull("values", list);
            this.operator = string2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.operator);
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.fieldName);
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeStartArray("$each");
            for (TItem TItem : this.values) {
                BuildersHelper.encodeValue(bsonDocumentWriter, TItem, codecRegistry);
            }
            bsonDocumentWriter.writeEndArray();
            this.writeAdditionalFields(bsonDocumentWriter, clazz, codecRegistry);
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        protected <TDocument> void writeAdditionalFields(BsonDocumentWriter bsonDocumentWriter, Class<TDocument> clazz, CodecRegistry codecRegistry) {
        }

        protected String additionalFieldsToString() {
            return "";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            WithEachUpdate withEachUpdate = (WithEachUpdate)object;
            if (!this.fieldName.equals(withEachUpdate.fieldName)) {
                return false;
            }
            if (!this.values.equals(withEachUpdate.values)) {
                return false;
            }
            return Objects.equals(this.operator, withEachUpdate.operator);
        }

        public int hashCode() {
            int n = this.fieldName.hashCode();
            n = 31 * n + this.values.hashCode();
            n = 31 * n + (this.operator != null ? this.operator.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "Each Update{fieldName='" + this.fieldName + '\'' + ", operator='" + this.operator + '\'' + ", values=" + this.values + this.additionalFieldsToString() + '}';
        }
    }

    private static class PushUpdate<TItem>
    extends WithEachUpdate<TItem> {
        private final PushOptions options;

        PushUpdate(String string, List<TItem> list, PushOptions pushOptions) {
            super(string, list, "$push");
            this.options = Assertions.notNull("options", pushOptions);
        }

        @Override
        protected <TDocument> void writeAdditionalFields(BsonDocumentWriter bsonDocumentWriter, Class<TDocument> clazz, CodecRegistry codecRegistry) {
            Integer n;
            Integer n2;
            Integer n3 = this.options.getPosition();
            if (n3 != null) {
                bsonDocumentWriter.writeInt32("$position", n3);
            }
            if ((n2 = this.options.getSlice()) != null) {
                bsonDocumentWriter.writeInt32("$slice", n2);
            }
            if ((n = this.options.getSort()) != null) {
                bsonDocumentWriter.writeInt32("$sort", n);
            } else {
                Bson bson = this.options.getSortDocument();
                if (bson != null) {
                    bsonDocumentWriter.writeName("$sort");
                    BuildersHelper.encodeValue(bsonDocumentWriter, bson, codecRegistry);
                }
            }
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            PushUpdate pushUpdate = (PushUpdate)object;
            return this.options.equals(pushUpdate.options);
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + this.options.hashCode();
            return n;
        }

        @Override
        protected String additionalFieldsToString() {
            return ", options=" + this.options;
        }
    }

    private static class PullAllUpdate<TItem>
    implements Bson {
        private final String fieldName;
        private final List<TItem> values;

        PullAllUpdate(String string, List<TItem> list) {
            this.fieldName = Assertions.notNull("fieldName", string);
            this.values = Assertions.notNull("values", list);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName("$pullAll");
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.fieldName);
            bsonDocumentWriter.writeStartArray();
            for (TItem TItem : this.values) {
                BuildersHelper.encodeValue(bsonDocumentWriter, TItem, codecRegistry);
            }
            bsonDocumentWriter.writeEndArray();
            bsonDocumentWriter.writeEndDocument();
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            PullAllUpdate pullAllUpdate = (PullAllUpdate)object;
            if (!this.fieldName.equals(pullAllUpdate.fieldName)) {
                return false;
            }
            return this.values.equals(pullAllUpdate.values);
        }

        public int hashCode() {
            int n = this.fieldName.hashCode();
            n = 31 * n + this.values.hashCode();
            return n;
        }

        public String toString() {
            return "Update{fieldName='" + this.fieldName + '\'' + ", operator='$pullAll', value=" + this.values + '}';
        }
    }
}

