/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.MongoTimeUnit;
import com.mongodb.client.model.QuantileMethod;
import com.mongodb.client.model.Window;
import com.mongodb.client.model.WindowOutputField;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class WindowOutputFields {
    public static WindowOutputField of(BsonField bsonField) {
        return new BsonFieldWindowOutputField(Assertions.notNull("windowOutputField", bsonField));
    }

    public static <TExpression> WindowOutputField sum(String string, TExpression TExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$sum", TExpression, window);
    }

    public static <TExpression> WindowOutputField avg(String string, TExpression TExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$avg", TExpression, window);
    }

    public static <InExpression, PExpression> WindowOutputField percentile(String string, InExpression InExpression, PExpression PExpression, QuantileMethod quantileMethod, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("inExpression", InExpression);
        Assertions.notNull("pExpression", PExpression);
        Assertions.notNull("method", quantileMethod);
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(3);
        linkedHashMap.put(ParamName.INPUT, InExpression);
        linkedHashMap.put(ParamName.P_LOWERCASE, PExpression);
        linkedHashMap.put(ParamName.METHOD, quantileMethod.toBsonValue());
        return WindowOutputFields.compoundParameterWindowFunction(string, "$percentile", linkedHashMap, window);
    }

    public static <InExpression> WindowOutputField median(String string, InExpression InExpression, QuantileMethod quantileMethod, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("inExpression", InExpression);
        Assertions.notNull("method", quantileMethod);
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(2);
        linkedHashMap.put(ParamName.INPUT, InExpression);
        linkedHashMap.put(ParamName.METHOD, quantileMethod.toBsonValue());
        return WindowOutputFields.compoundParameterWindowFunction(string, "$median", linkedHashMap, window);
    }

    public static <TExpression> WindowOutputField stdDevSamp(String string, TExpression TExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$stdDevSamp", TExpression, window);
    }

    public static <TExpression> WindowOutputField stdDevPop(String string, TExpression TExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$stdDevPop", TExpression, window);
    }

    public static <TExpression> WindowOutputField min(String string, TExpression TExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$min", TExpression, window);
    }

    public static <InExpression, NExpression> WindowOutputField minN(String string, InExpression InExpression, NExpression NExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("inExpression", InExpression);
        Assertions.notNull("nExpression", NExpression);
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(3);
        linkedHashMap.put(ParamName.INPUT, InExpression);
        linkedHashMap.put(ParamName.N_LOWERCASE, NExpression);
        return WindowOutputFields.compoundParameterWindowFunction(string, "$minN", linkedHashMap, window);
    }

    public static <TExpression> WindowOutputField max(String string, TExpression TExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$max", TExpression, window);
    }

    public static <InExpression, NExpression> WindowOutputField maxN(String string, InExpression InExpression, NExpression NExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("inExpression", InExpression);
        Assertions.notNull("nExpression", NExpression);
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(3);
        linkedHashMap.put(ParamName.INPUT, InExpression);
        linkedHashMap.put(ParamName.N_LOWERCASE, NExpression);
        return WindowOutputFields.compoundParameterWindowFunction(string, "$maxN", linkedHashMap, window);
    }

    public static WindowOutputField count(String string, @Nullable Window window) {
        Assertions.notNull("path", string);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$count", null, window);
    }

    public static <TExpression> WindowOutputField derivative(String string, TExpression TExpression, Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        Assertions.notNull("window", window);
        HashMap<ParamName, Object> hashMap = new HashMap<ParamName, Object>(1);
        hashMap.put(ParamName.INPUT, TExpression);
        return WindowOutputFields.compoundParameterWindowFunction(string, "$derivative", hashMap, window);
    }

    public static <TExpression> WindowOutputField timeDerivative(String string, TExpression TExpression, Window window, MongoTimeUnit mongoTimeUnit) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        Assertions.notNull("window", window);
        Assertions.notNull("unit", mongoTimeUnit);
        com.mongodb.assertions.Assertions.isTrueArgument("unit must be either of WEEK, DAY, HOUR, MINUTE, SECOND, MILLISECOND", mongoTimeUnit.fixed());
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(2);
        linkedHashMap.put(ParamName.INPUT, TExpression);
        linkedHashMap.put(ParamName.UNIT, mongoTimeUnit.value());
        return WindowOutputFields.compoundParameterWindowFunction(string, "$derivative", linkedHashMap, window);
    }

    public static <TExpression> WindowOutputField integral(String string, TExpression TExpression, Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        Assertions.notNull("window", window);
        HashMap<ParamName, Object> hashMap = new HashMap<ParamName, Object>(1);
        hashMap.put(ParamName.INPUT, TExpression);
        return WindowOutputFields.compoundParameterWindowFunction(string, "$integral", hashMap, window);
    }

    public static <TExpression> WindowOutputField timeIntegral(String string, TExpression TExpression, Window window, MongoTimeUnit mongoTimeUnit) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        Assertions.notNull("window", window);
        Assertions.notNull("unit", mongoTimeUnit);
        com.mongodb.assertions.Assertions.isTrueArgument("unit must be either of WEEK, DAY, HOUR, MINUTE, SECOND, MILLISECOND", mongoTimeUnit.fixed());
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(2);
        linkedHashMap.put(ParamName.INPUT, TExpression);
        linkedHashMap.put(ParamName.UNIT, mongoTimeUnit.value());
        return WindowOutputFields.compoundParameterWindowFunction(string, "$integral", linkedHashMap, window);
    }

    public static <TExpression> WindowOutputField covarianceSamp(String string, TExpression TExpression, TExpression TExpression2, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression1", TExpression);
        Assertions.notNull("expression2", TExpression2);
        ArrayList<TExpression> arrayList = new ArrayList<TExpression>(2);
        arrayList.add(TExpression);
        arrayList.add(TExpression2);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$covarianceSamp", arrayList, window);
    }

    public static <TExpression> WindowOutputField covariancePop(String string, TExpression TExpression, TExpression TExpression2, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression1", TExpression);
        Assertions.notNull("expression2", TExpression2);
        ArrayList<TExpression> arrayList = new ArrayList<TExpression>(2);
        arrayList.add(TExpression);
        arrayList.add(TExpression2);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$covariancePop", arrayList, window);
    }

    public static <TExpression> WindowOutputField expMovingAvg(String string, TExpression TExpression, int n) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        com.mongodb.assertions.Assertions.isTrueArgument("n > 0", n > 0);
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(2);
        linkedHashMap.put(ParamName.INPUT, TExpression);
        linkedHashMap.put(ParamName.N_UPPERCASE, n);
        return WindowOutputFields.compoundParameterWindowFunction(string, "$expMovingAvg", linkedHashMap, null);
    }

    public static <TExpression> WindowOutputField expMovingAvg(String string, TExpression TExpression, double d) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        com.mongodb.assertions.Assertions.isTrueArgument("alpha > 0", d > 0.0);
        com.mongodb.assertions.Assertions.isTrueArgument("alpha < 1", d < 1.0);
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(2);
        linkedHashMap.put(ParamName.INPUT, TExpression);
        linkedHashMap.put(ParamName.ALPHA, d);
        return WindowOutputFields.compoundParameterWindowFunction(string, "$expMovingAvg", linkedHashMap, null);
    }

    public static <TExpression> WindowOutputField push(String string, TExpression TExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$push", TExpression, window);
    }

    public static <TExpression> WindowOutputField addToSet(String string, TExpression TExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$addToSet", TExpression, window);
    }

    public static <TExpression> WindowOutputField first(String string, TExpression TExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$first", TExpression, window);
    }

    public static <InExpression, NExpression> WindowOutputField firstN(String string, InExpression InExpression, NExpression NExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("inExpression", InExpression);
        Assertions.notNull("nExpression", NExpression);
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(3);
        linkedHashMap.put(ParamName.INPUT, InExpression);
        linkedHashMap.put(ParamName.N_LOWERCASE, NExpression);
        return WindowOutputFields.compoundParameterWindowFunction(string, "$firstN", linkedHashMap, window);
    }

    public static <OutExpression> WindowOutputField top(String string, Bson bson, OutExpression OutExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("sortBy", bson);
        Assertions.notNull("outExpression", OutExpression);
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(3);
        linkedHashMap.put(ParamName.SORT_BY, bson);
        linkedHashMap.put(ParamName.OUTPUT, OutExpression);
        return WindowOutputFields.compoundParameterWindowFunction(string, "$top", linkedHashMap, window);
    }

    public static <OutExpression, NExpression> WindowOutputField topN(String string, Bson bson, OutExpression OutExpression, NExpression NExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("sortBy", bson);
        Assertions.notNull("outExpression", OutExpression);
        Assertions.notNull("nExpression", NExpression);
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(3);
        linkedHashMap.put(ParamName.SORT_BY, bson);
        linkedHashMap.put(ParamName.OUTPUT, OutExpression);
        linkedHashMap.put(ParamName.N_LOWERCASE, NExpression);
        return WindowOutputFields.compoundParameterWindowFunction(string, "$topN", linkedHashMap, window);
    }

    public static <TExpression> WindowOutputField last(String string, TExpression TExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$last", TExpression, window);
    }

    public static <InExpression, NExpression> WindowOutputField lastN(String string, InExpression InExpression, NExpression NExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("inExpression", InExpression);
        Assertions.notNull("nExpression", NExpression);
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(3);
        linkedHashMap.put(ParamName.INPUT, InExpression);
        linkedHashMap.put(ParamName.N_LOWERCASE, NExpression);
        return WindowOutputFields.compoundParameterWindowFunction(string, "$lastN", linkedHashMap, window);
    }

    public static <OutExpression> WindowOutputField bottom(String string, Bson bson, OutExpression OutExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("sortBy", bson);
        Assertions.notNull("outExpression", OutExpression);
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(3);
        linkedHashMap.put(ParamName.SORT_BY, bson);
        linkedHashMap.put(ParamName.OUTPUT, OutExpression);
        return WindowOutputFields.compoundParameterWindowFunction(string, "$bottom", linkedHashMap, window);
    }

    public static <OutExpression, NExpression> WindowOutputField bottomN(String string, Bson bson, OutExpression OutExpression, NExpression NExpression, @Nullable Window window) {
        Assertions.notNull("path", string);
        Assertions.notNull("sortBy", bson);
        Assertions.notNull("outExpression", OutExpression);
        Assertions.notNull("nExpression", NExpression);
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(3);
        linkedHashMap.put(ParamName.SORT_BY, bson);
        linkedHashMap.put(ParamName.OUTPUT, OutExpression);
        linkedHashMap.put(ParamName.N_LOWERCASE, NExpression);
        return WindowOutputFields.compoundParameterWindowFunction(string, "$bottomN", linkedHashMap, window);
    }

    public static <TExpression> WindowOutputField shift(String string, TExpression TExpression, @Nullable TExpression TExpression2, int n) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        LinkedHashMap<ParamName, Object> linkedHashMap = new LinkedHashMap<ParamName, Object>(3);
        linkedHashMap.put(ParamName.OUTPUT, TExpression);
        linkedHashMap.put(ParamName.BY, n);
        if (TExpression2 != null) {
            linkedHashMap.put(ParamName.DEFAULT, TExpression2);
        }
        return WindowOutputFields.compoundParameterWindowFunction(string, "$shift", linkedHashMap, null);
    }

    public static WindowOutputField documentNumber(String string) {
        Assertions.notNull("path", string);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$documentNumber", null, null);
    }

    public static WindowOutputField rank(String string) {
        Assertions.notNull("path", string);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$rank", null, null);
    }

    public static WindowOutputField denseRank(String string) {
        Assertions.notNull("path", string);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$denseRank", null, null);
    }

    public static <TExpression> WindowOutputField locf(String string, TExpression TExpression) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$locf", TExpression, null);
    }

    public static <TExpression> WindowOutputField linearFill(String string, TExpression TExpression) {
        Assertions.notNull("path", string);
        Assertions.notNull("expression", TExpression);
        return WindowOutputFields.simpleParameterWindowFunction(string, "$linearFill", TExpression, null);
    }

    private static WindowOutputField simpleParameterWindowFunction(String string, String string2, @Nullable Object object, @Nullable Window window) {
        return new BsonFieldWindowOutputField(new BsonField(string, new SimpleParameterFunctionAndWindow(string2, object, window)));
    }

    private static WindowOutputField compoundParameterWindowFunction(String string, String string2, Map<ParamName, Object> map, @Nullable Window window) {
        return new BsonFieldWindowOutputField(new BsonField(string, new CompoundParameterFunctionAndWindow(string2, map, window)));
    }

    private WindowOutputFields() {
        throw new UnsupportedOperationException();
    }

    private static final class BsonFieldWindowOutputField
    implements WindowOutputField {
        private final BsonField wrapped;

        BsonFieldWindowOutputField(BsonField bsonField) {
            this.wrapped = com.mongodb.assertions.Assertions.assertNotNull(bsonField);
        }

        @Override
        public BsonField toBsonField() {
            return this.wrapped;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BsonFieldWindowOutputField bsonFieldWindowOutputField = (BsonFieldWindowOutputField)object;
            return this.wrapped.equals(bsonFieldWindowOutputField.wrapped);
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }

    private static enum ParamName {
        INPUT("input"),
        UNIT("unit"),
        N_UPPERCASE("N"),
        N_LOWERCASE("n"),
        P_LOWERCASE("p"),
        ALPHA("alpha"),
        OUTPUT("output"),
        BY("by"),
        DEFAULT("default"),
        SORT_BY("sortBy"),
        METHOD("method");

        private final String value;

        private ParamName(String string2) {
            this.value = string2;
        }

        String value() {
            return this.value;
        }
    }

    private static final class SimpleParameterFunctionAndWindow
    extends AbstractFunctionAndWindow {
        @Nullable
        private final Object expression;

        SimpleParameterFunctionAndWindow(String string, @Nullable Object object, @Nullable Window window) {
            super(string, window);
            this.expression = object;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.functionName());
            if (this.expression == null) {
                bsonDocumentWriter.writeStartDocument();
                bsonDocumentWriter.writeEndDocument();
            } else {
                BuildersHelper.encodeValue(bsonDocumentWriter, this.expression, codecRegistry);
            }
            this.writeWindow(codecRegistry, bsonDocumentWriter);
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SimpleParameterFunctionAndWindow simpleParameterFunctionAndWindow = (SimpleParameterFunctionAndWindow)object;
            return this.functionName().equals(simpleParameterFunctionAndWindow.functionName()) && Objects.equals(this.expression, simpleParameterFunctionAndWindow.expression) && this.window().equals(simpleParameterFunctionAndWindow.window());
        }

        public int hashCode() {
            return Objects.hash(this.functionName(), this.expression, this.window());
        }

        public String toString() {
            return "WindowFunction{name='" + this.functionName() + '\'' + ", expression=" + this.expression + ", window=" + this.window() + '}';
        }
    }

    private static final class CompoundParameterFunctionAndWindow
    extends AbstractFunctionAndWindow {
        private final Map<ParamName, Object> args;

        CompoundParameterFunctionAndWindow(String string, Map<ParamName, Object> map, @Nullable Window window) {
            super(string, window);
            this.args = map;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeName(this.functionName());
            bsonDocumentWriter.writeStartDocument();
            this.args.forEach((paramName, object) -> {
                bsonDocumentWriter.writeName(paramName.value());
                BuildersHelper.encodeValue(bsonDocumentWriter, object, codecRegistry);
            });
            bsonDocumentWriter.writeEndDocument();
            this.writeWindow(codecRegistry, bsonDocumentWriter);
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CompoundParameterFunctionAndWindow compoundParameterFunctionAndWindow = (CompoundParameterFunctionAndWindow)object;
            return this.functionName().equals(compoundParameterFunctionAndWindow.functionName()) && Objects.equals(this.args, compoundParameterFunctionAndWindow.args) && this.window().equals(compoundParameterFunctionAndWindow.window());
        }

        public int hashCode() {
            return Objects.hash(this.functionName(), this.args, this.window());
        }

        public String toString() {
            return "WindowFunction{name='" + this.functionName() + '\'' + ", args=" + this.args + ", window=" + this.window() + '}';
        }
    }

    private static abstract class AbstractFunctionAndWindow
    implements Bson {
        private final String functionName;
        @Nullable
        private final Window window;

        AbstractFunctionAndWindow(String string, @Nullable Window window) {
            this.functionName = string;
            this.window = window;
        }

        final void writeWindow(CodecRegistry codecRegistry, BsonDocumentWriter bsonDocumentWriter) {
            if (this.window != null) {
                bsonDocumentWriter.writeName("window");
                BuildersHelper.encodeValue(bsonDocumentWriter, this.window, codecRegistry);
            }
        }

        final String functionName() {
            return this.functionName;
        }

        final Optional<Window> window() {
            return Optional.ofNullable(this.window);
        }
    }
}

