/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.MongoTimeUnit;
import com.mongodb.client.model.Window;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.Decimal128;

public final class Windows {
    public static Window of(Bson bson) {
        return new BsonWindow(Assertions.notNull("window", bson));
    }

    public static Window documents(int n, int n2) {
        com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", n <= n2);
        return new SimpleWindow<Integer, Integer>("documents", n, n2, null);
    }

    public static Window documents(Bound bound, int n) {
        Assertions.notNull("lower", bound);
        if (bound == Bound.CURRENT) {
            com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", n >= 0);
        }
        return new SimpleWindow<String, Integer>("documents", bound.value(), n, null);
    }

    public static Window documents(int n, Bound bound) {
        Assertions.notNull("upper", bound);
        if (bound == Bound.CURRENT) {
            com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", n <= 0);
        }
        return new SimpleWindow<Integer, String>("documents", n, bound.value(), null);
    }

    public static Window documents(Bound bound, Bound bound2) {
        Assertions.notNull("lower", bound);
        Assertions.notNull("upper", bound2);
        return new SimpleWindow<String, String>("documents", bound.value(), bound2.value(), null);
    }

    public static Window range(long l, long l2) {
        com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", l <= l2);
        return new SimpleWindow<Long, Long>("range", l, l2, null);
    }

    public static Window range(double d, double d2) {
        com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", d <= d2);
        return new SimpleWindow<Double, Double>("range", d, d2, null);
    }

    public static Window range(Decimal128 decimal128, Decimal128 decimal1282) {
        Assertions.notNull("lower", decimal128);
        Assertions.notNull("upper", decimal1282);
        com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", decimal128.compareTo(decimal1282) <= 0);
        return new SimpleWindow<Decimal128, Decimal128>("range", decimal128, decimal1282, null);
    }

    public static Window range(Bound bound, long l) {
        Assertions.notNull("lower", bound);
        return new SimpleWindow<String, Long>("range", bound.value(), l, null);
    }

    public static Window range(Bound bound, double d) {
        Assertions.notNull("lower", bound);
        return new SimpleWindow<String, Double>("range", bound.value(), d, null);
    }

    public static Window range(Bound bound, Decimal128 decimal128) {
        Assertions.notNull("lower", bound);
        Assertions.notNull("upper", decimal128);
        return new SimpleWindow<String, Decimal128>("range", bound.value(), decimal128, null);
    }

    public static Window range(long l, Bound bound) {
        Assertions.notNull("upper", bound);
        return new SimpleWindow<Long, String>("range", l, bound.value(), null);
    }

    public static Window range(double d, Bound bound) {
        Assertions.notNull("upper", bound);
        return new SimpleWindow<Double, String>("range", d, bound.value(), null);
    }

    public static Window range(Decimal128 decimal128, Bound bound) {
        Assertions.notNull("lower", decimal128);
        Assertions.notNull("upper", bound);
        return new SimpleWindow<Decimal128, String>("range", decimal128, bound.value(), null);
    }

    public static Window timeRange(long l, long l2, MongoTimeUnit mongoTimeUnit) {
        Assertions.notNull("unit", mongoTimeUnit);
        com.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", l <= l2);
        return new SimpleWindow<Long, Long>("range", l, l2, mongoTimeUnit);
    }

    public static Window timeRange(Bound bound, long l, MongoTimeUnit mongoTimeUnit) {
        Assertions.notNull("lower", bound);
        Assertions.notNull("unit", mongoTimeUnit);
        return new SimpleWindow<String, Long>("range", bound.value(), l, mongoTimeUnit);
    }

    public static Window timeRange(long l, MongoTimeUnit mongoTimeUnit, Bound bound) {
        Assertions.notNull("unit", mongoTimeUnit);
        Assertions.notNull("upper", bound);
        return new SimpleWindow<Long, String>("range", l, bound.value(), mongoTimeUnit);
    }

    private Windows() {
        throw new UnsupportedOperationException();
    }

    private static final class BsonWindow
    implements Window {
        private final Bson wrapped;

        BsonWindow(Bson bson) {
            this.wrapped = com.mongodb.assertions.Assertions.assertNotNull(bson);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            return this.wrapped.toBsonDocument(clazz, codecRegistry);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BsonWindow bsonWindow = (BsonWindow)object;
            return this.wrapped.equals(bsonWindow.wrapped);
        }

        public int hashCode() {
            return Objects.hash(this.wrapped);
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }

    private static class SimpleWindow<L, U>
    implements Window {
        static final String TYPE_POSITION_BASED = "documents";
        static final String TYPE_RANGE_BASED = "range";
        private final String type;
        private final L lower;
        private final U upper;
        @Nullable
        private final MongoTimeUnit unit;

        SimpleWindow(String string, L l, U u, @Nullable MongoTimeUnit mongoTimeUnit) {
            this.lower = l;
            this.upper = u;
            this.type = string;
            this.unit = mongoTimeUnit;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(new BsonDocument());
            bsonDocumentWriter.writeStartDocument();
            bsonDocumentWriter.writeStartArray(this.type);
            BuildersHelper.encodeValue(bsonDocumentWriter, this.lower, codecRegistry);
            BuildersHelper.encodeValue(bsonDocumentWriter, this.upper, codecRegistry);
            bsonDocumentWriter.writeEndArray();
            if (this.unit != null) {
                bsonDocumentWriter.writeString("unit", this.unit.value());
            }
            bsonDocumentWriter.writeEndDocument();
            return bsonDocumentWriter.getDocument();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SimpleWindow simpleWindow = (SimpleWindow)object;
            return this.type.equals(simpleWindow.type) && this.lower.equals(simpleWindow.lower) && this.upper.equals(simpleWindow.upper) && this.unit == simpleWindow.unit;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.lower, this.upper, this.unit});
        }

        public String toString() {
            return "Window{type=" + this.type + ", lower=" + this.lower + ", upper=" + this.upper + ", unit=" + (Object)((Object)this.unit) + '}';
        }
    }

    public static enum Bound {
        CURRENT("current"),
        UNBOUNDED("unbounded");

        private final String value;

        private Bound(String string2) {
            this.value = string2;
        }

        String value() {
            return this.value;
        }
    }
}

