/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.bulk;

import com.mongodb.MongoNamespace;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.bulk.ClientDeleteManyOptions;
import com.mongodb.client.model.bulk.ClientDeleteOneOptions;
import com.mongodb.client.model.bulk.ClientNamespacedDeleteManyModel;
import com.mongodb.client.model.bulk.ClientNamespacedDeleteOneModel;
import com.mongodb.client.model.bulk.ClientNamespacedInsertOneModel;
import com.mongodb.client.model.bulk.ClientNamespacedReplaceOneModel;
import com.mongodb.client.model.bulk.ClientNamespacedUpdateManyModel;
import com.mongodb.client.model.bulk.ClientNamespacedUpdateOneModel;
import com.mongodb.client.model.bulk.ClientReplaceOneOptions;
import com.mongodb.client.model.bulk.ClientUpdateManyOptions;
import com.mongodb.client.model.bulk.ClientUpdateOneOptions;
import com.mongodb.internal.client.model.bulk.ConcreteClientDeleteManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientDeleteOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientInsertOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedDeleteManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedDeleteOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedInsertOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedReplaceOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedUpdateManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedUpdateOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientReplaceOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientUpdateManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientUpdateOneModel;
import org.bson.conversions.Bson;

@Sealed
public interface ClientNamespacedWriteModel {
    public static <TDocument> ClientNamespacedInsertOneModel insertOne(MongoNamespace mongoNamespace, TDocument TDocument) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("document", TDocument);
        return new ConcreteClientNamespacedInsertOneModel(mongoNamespace, new ConcreteClientInsertOneModel(TDocument));
    }

    public static ClientNamespacedUpdateOneModel updateOne(MongoNamespace mongoNamespace, Bson bson, Bson bson2) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        Assertions.notNull("update", bson2);
        return new ConcreteClientNamespacedUpdateOneModel(mongoNamespace, new ConcreteClientUpdateOneModel(bson, bson2, null, null));
    }

    public static ClientNamespacedUpdateOneModel updateOne(MongoNamespace mongoNamespace, Bson bson, Bson bson2, ClientUpdateOneOptions clientUpdateOneOptions) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        Assertions.notNull("update", bson2);
        Assertions.notNull("options", clientUpdateOneOptions);
        return new ConcreteClientNamespacedUpdateOneModel(mongoNamespace, new ConcreteClientUpdateOneModel(bson, bson2, null, clientUpdateOneOptions));
    }

    public static ClientNamespacedUpdateOneModel updateOne(MongoNamespace mongoNamespace, Bson bson, Iterable<? extends Bson> iterable) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        Assertions.notNull("updatePipeline", iterable);
        return new ConcreteClientNamespacedUpdateOneModel(mongoNamespace, new ConcreteClientUpdateOneModel(bson, null, iterable, null));
    }

    public static ClientNamespacedUpdateOneModel updateOne(MongoNamespace mongoNamespace, Bson bson, Iterable<? extends Bson> iterable, ClientUpdateOneOptions clientUpdateOneOptions) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        Assertions.notNull("updatePipeline", iterable);
        Assertions.notNull("options", clientUpdateOneOptions);
        return new ConcreteClientNamespacedUpdateOneModel(mongoNamespace, new ConcreteClientUpdateOneModel(bson, null, iterable, clientUpdateOneOptions));
    }

    public static ClientNamespacedUpdateManyModel updateMany(MongoNamespace mongoNamespace, Bson bson, Bson bson2) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        Assertions.notNull("update", bson2);
        return new ConcreteClientNamespacedUpdateManyModel(mongoNamespace, new ConcreteClientUpdateManyModel(bson, bson2, null, null));
    }

    public static ClientNamespacedUpdateManyModel updateMany(MongoNamespace mongoNamespace, Bson bson, Bson bson2, ClientUpdateManyOptions clientUpdateManyOptions) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        Assertions.notNull("update", bson2);
        Assertions.notNull("options", clientUpdateManyOptions);
        return new ConcreteClientNamespacedUpdateManyModel(mongoNamespace, new ConcreteClientUpdateManyModel(bson, bson2, null, clientUpdateManyOptions));
    }

    public static ClientNamespacedUpdateManyModel updateMany(MongoNamespace mongoNamespace, Bson bson, Iterable<? extends Bson> iterable) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        Assertions.notNull("updatePipeline", iterable);
        return new ConcreteClientNamespacedUpdateManyModel(mongoNamespace, new ConcreteClientUpdateManyModel(bson, null, iterable, null));
    }

    public static ClientNamespacedUpdateManyModel updateMany(MongoNamespace mongoNamespace, Bson bson, Iterable<? extends Bson> iterable, ClientUpdateManyOptions clientUpdateManyOptions) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        Assertions.notNull("updatePipeline", iterable);
        Assertions.notNull("options", clientUpdateManyOptions);
        return new ConcreteClientNamespacedUpdateManyModel(mongoNamespace, new ConcreteClientUpdateManyModel(bson, null, iterable, clientUpdateManyOptions));
    }

    public static <TDocument> ClientNamespacedReplaceOneModel replaceOne(MongoNamespace mongoNamespace, Bson bson, TDocument TDocument) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        Assertions.notNull("replacement", TDocument);
        return new ConcreteClientNamespacedReplaceOneModel(mongoNamespace, new ConcreteClientReplaceOneModel(bson, TDocument, null));
    }

    public static <TDocument> ClientNamespacedReplaceOneModel replaceOne(MongoNamespace mongoNamespace, Bson bson, TDocument TDocument, ClientReplaceOneOptions clientReplaceOneOptions) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        Assertions.notNull("replacement", TDocument);
        Assertions.notNull("options", clientReplaceOneOptions);
        return new ConcreteClientNamespacedReplaceOneModel(mongoNamespace, new ConcreteClientReplaceOneModel(bson, TDocument, clientReplaceOneOptions));
    }

    public static ClientNamespacedDeleteOneModel deleteOne(MongoNamespace mongoNamespace, Bson bson) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        return new ConcreteClientNamespacedDeleteOneModel(mongoNamespace, new ConcreteClientDeleteOneModel(bson, null));
    }

    public static ClientNamespacedDeleteOneModel deleteOne(MongoNamespace mongoNamespace, Bson bson, ClientDeleteOneOptions clientDeleteOneOptions) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        Assertions.notNull("options", clientDeleteOneOptions);
        return new ConcreteClientNamespacedDeleteOneModel(mongoNamespace, new ConcreteClientDeleteOneModel(bson, clientDeleteOneOptions));
    }

    public static ClientNamespacedDeleteManyModel deleteMany(MongoNamespace mongoNamespace, Bson bson) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        return new ConcreteClientNamespacedDeleteManyModel(mongoNamespace, new ConcreteClientDeleteManyModel(bson, null));
    }

    public static ClientNamespacedDeleteManyModel deleteMany(MongoNamespace mongoNamespace, Bson bson, ClientDeleteManyOptions clientDeleteManyOptions) {
        Assertions.notNull("namespace", mongoNamespace);
        Assertions.notNull("filter", bson);
        Assertions.notNull("options", clientDeleteManyOptions);
        return new ConcreteClientNamespacedDeleteManyModel(mongoNamespace, new ConcreteClientDeleteManyModel(bson, clientDeleteManyOptions));
    }
}

