/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.changestream;

import com.mongodb.MongoNamespace;
import com.mongodb.client.model.changestream.ChangeStreamDocumentCodec;
import com.mongodb.client.model.changestream.OperationType;
import com.mongodb.client.model.changestream.SplitEvent;
import com.mongodb.client.model.changestream.UpdateDescription;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonTimestamp;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonExtraElements;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import org.bson.codecs.pojo.annotations.BsonProperty;

public final class ChangeStreamDocument<TDocument> {
    @BsonId
    private final BsonDocument resumeToken;
    private final BsonDocument namespaceDocument;
    private final BsonDocument destinationNamespaceDocument;
    private final TDocument fullDocument;
    private final TDocument fullDocumentBeforeChange;
    private final BsonDocument documentKey;
    private final BsonTimestamp clusterTime;
    @BsonProperty(value="operationType")
    private final String operationTypeString;
    @BsonIgnore
    private final OperationType operationType;
    private final UpdateDescription updateDescription;
    private final BsonInt64 txnNumber;
    private final BsonDocument lsid;
    private final BsonDateTime wallTime;
    private final SplitEvent splitEvent;
    @BsonExtraElements
    private final BsonDocument extraElements;

    @BsonCreator
    public ChangeStreamDocument(@Nullable @BsonProperty(value="operationType") String string, @BsonProperty(value="resumeToken") BsonDocument bsonDocument, @Nullable @BsonProperty(value="ns") BsonDocument bsonDocument2, @Nullable @BsonProperty(value="to") BsonDocument bsonDocument3, @Nullable @BsonProperty(value="fullDocument") TDocument TDocument, @Nullable @BsonProperty(value="fullDocumentBeforeChange") TDocument TDocument2, @Nullable @BsonProperty(value="documentKey") BsonDocument bsonDocument4, @Nullable @BsonProperty(value="clusterTime") BsonTimestamp bsonTimestamp, @Nullable @BsonProperty(value="updateDescription") UpdateDescription updateDescription, @Nullable @BsonProperty(value="txnNumber") BsonInt64 bsonInt64, @Nullable @BsonProperty(value="lsid") BsonDocument bsonDocument5, @Nullable @BsonProperty(value="wallTime") BsonDateTime bsonDateTime, @Nullable @BsonProperty(value="splitEvent") SplitEvent splitEvent, @Nullable @BsonProperty BsonDocument bsonDocument6) {
        this.resumeToken = bsonDocument;
        this.namespaceDocument = bsonDocument2;
        this.destinationNamespaceDocument = bsonDocument3;
        this.fullDocumentBeforeChange = TDocument2;
        this.documentKey = bsonDocument4;
        this.fullDocument = TDocument;
        this.clusterTime = bsonTimestamp;
        this.operationTypeString = string;
        this.operationType = string == null ? null : OperationType.fromString(string);
        this.updateDescription = updateDescription;
        this.txnNumber = bsonInt64;
        this.lsid = bsonDocument5;
        this.wallTime = bsonDateTime;
        this.splitEvent = splitEvent;
        this.extraElements = bsonDocument6;
    }

    public BsonDocument getResumeToken() {
        return this.resumeToken;
    }

    @BsonIgnore
    @Nullable
    public MongoNamespace getNamespace() {
        if (this.namespaceDocument == null) {
            return null;
        }
        if (!this.namespaceDocument.containsKey("db") || !this.namespaceDocument.containsKey("coll")) {
            return null;
        }
        return new MongoNamespace(this.namespaceDocument.getString("db").getValue(), this.namespaceDocument.getString("coll").getValue());
    }

    @BsonProperty(value="ns")
    @Nullable
    public BsonDocument getNamespaceDocument() {
        return this.namespaceDocument;
    }

    @BsonIgnore
    @Nullable
    public MongoNamespace getDestinationNamespace() {
        if (this.destinationNamespaceDocument == null) {
            return null;
        }
        return new MongoNamespace(this.destinationNamespaceDocument.getString("db").getValue(), this.destinationNamespaceDocument.getString("coll").getValue());
    }

    @BsonProperty(value="to")
    @Nullable
    public BsonDocument getDestinationNamespaceDocument() {
        return this.destinationNamespaceDocument;
    }

    @BsonIgnore
    @Nullable
    public String getDatabaseName() {
        if (this.namespaceDocument == null) {
            return null;
        }
        if (!this.namespaceDocument.containsKey("db")) {
            return null;
        }
        return this.namespaceDocument.getString("db").getValue();
    }

    @Nullable
    public TDocument getFullDocument() {
        return this.fullDocument;
    }

    @Nullable
    public TDocument getFullDocumentBeforeChange() {
        return this.fullDocumentBeforeChange;
    }

    @Nullable
    public BsonDocument getDocumentKey() {
        return this.documentKey;
    }

    @Nullable
    public BsonTimestamp getClusterTime() {
        return this.clusterTime;
    }

    @Nullable
    public String getOperationTypeString() {
        return this.operationTypeString;
    }

    @Nullable
    public OperationType getOperationType() {
        return this.operationType;
    }

    @Nullable
    public UpdateDescription getUpdateDescription() {
        return this.updateDescription;
    }

    @Nullable
    public BsonInt64 getTxnNumber() {
        return this.txnNumber;
    }

    @Nullable
    public BsonDocument getLsid() {
        return this.lsid;
    }

    @Nullable
    public BsonDateTime getWallTime() {
        return this.wallTime;
    }

    @Nullable
    public SplitEvent getSplitEvent() {
        return this.splitEvent;
    }

    @Nullable
    public BsonDocument getExtraElements() {
        return this.extraElements;
    }

    public static <TFullDocument> Codec<ChangeStreamDocument<TFullDocument>> createCodec(Class<TFullDocument> clazz, CodecRegistry codecRegistry) {
        return new ChangeStreamDocumentCodec<TFullDocument>(clazz, codecRegistry);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ChangeStreamDocument changeStreamDocument = (ChangeStreamDocument)object;
        return Objects.equals(this.resumeToken, changeStreamDocument.resumeToken) && Objects.equals(this.namespaceDocument, changeStreamDocument.namespaceDocument) && Objects.equals(this.destinationNamespaceDocument, changeStreamDocument.destinationNamespaceDocument) && Objects.equals(this.fullDocument, changeStreamDocument.fullDocument) && Objects.equals(this.fullDocumentBeforeChange, changeStreamDocument.fullDocumentBeforeChange) && Objects.equals(this.documentKey, changeStreamDocument.documentKey) && Objects.equals(this.clusterTime, changeStreamDocument.clusterTime) && Objects.equals(this.operationTypeString, changeStreamDocument.operationTypeString) && Objects.equals(this.updateDescription, changeStreamDocument.updateDescription) && Objects.equals(this.txnNumber, changeStreamDocument.txnNumber) && Objects.equals(this.lsid, changeStreamDocument.lsid) && Objects.equals(this.wallTime, changeStreamDocument.wallTime) && Objects.equals(this.splitEvent, changeStreamDocument.splitEvent) && Objects.equals(this.extraElements, changeStreamDocument.extraElements);
    }

    public int hashCode() {
        return Objects.hash(this.resumeToken, this.namespaceDocument, this.destinationNamespaceDocument, this.fullDocument, this.fullDocumentBeforeChange, this.documentKey, this.clusterTime, this.operationTypeString, this.updateDescription, this.txnNumber, this.lsid, this.wallTime, this.splitEvent, this.extraElements);
    }

    public String toString() {
        return "ChangeStreamDocument{ operationType=" + this.operationTypeString + ", resumeToken=" + this.resumeToken + ", namespace=" + this.getNamespace() + ", destinationNamespace=" + this.getDestinationNamespace() + ", fullDocument=" + this.fullDocument + ", fullDocumentBeforeChange=" + this.fullDocumentBeforeChange + ", documentKey=" + this.documentKey + ", clusterTime=" + this.clusterTime + ", updateDescription=" + this.updateDescription + ", txnNumber=" + this.txnNumber + ", lsid=" + this.lsid + ", splitEvent=" + this.splitEvent + ", wallTime=" + this.wallTime + "}";
    }
}

