/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.changestream;

import java.util.Objects;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonProperty;

public final class SplitEvent {
    private final int fragment;
    private final int of;

    @BsonCreator
    public SplitEvent(@BsonProperty(value="fragment") int n, @BsonProperty(value="of") int n2) {
        this.fragment = n;
        this.of = n2;
    }

    public int getFragment() {
        return this.fragment;
    }

    public int getOf() {
        return this.of;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SplitEvent splitEvent = (SplitEvent)object;
        return this.fragment == splitEvent.fragment && this.of == splitEvent.of;
    }

    public int hashCode() {
        return Objects.hash(this.fragment, this.of);
    }

    public String toString() {
        return "SplitEvent{fragment=" + this.fragment + ", of=" + this.of + '}';
    }
}

