/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.changestream;

import com.mongodb.assertions.Assertions;
import java.util.Objects;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonProperty;

public final class TruncatedArray {
    private final String field;
    private final int newSize;

    @BsonCreator
    public TruncatedArray(@BsonProperty(value="field") String string, @BsonProperty(value="newSize") int n) {
        this.field = Assertions.notNull("field", string);
        Assertions.isTrueArgument("newSize >= 0", n >= 0);
        this.newSize = n;
    }

    public String getField() {
        return this.field;
    }

    public int getNewSize() {
        return this.newSize;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TruncatedArray truncatedArray = (TruncatedArray)object;
        return this.newSize == truncatedArray.newSize && this.field.equals(truncatedArray.field);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.newSize);
    }

    public String toString() {
        return "TruncatedArray{field=" + this.field + ", newSize=" + this.newSize + '}';
    }
}

