/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.changestream;

import com.mongodb.client.model.changestream.TruncatedArray;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bson.BsonDocument;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonProperty;

public final class UpdateDescription {
    private final List<String> removedFields;
    private final BsonDocument updatedFields;
    private final List<TruncatedArray> truncatedArrays;
    private final BsonDocument disambiguatedPaths;

    public UpdateDescription(@Nullable List<String> list, @Nullable BsonDocument bsonDocument) {
        this(list, bsonDocument, null);
    }

    public UpdateDescription(@Nullable List<String> list, @Nullable BsonDocument bsonDocument, @Nullable List<TruncatedArray> list2) {
        this(list, bsonDocument, list2, null);
    }

    @BsonCreator
    public UpdateDescription(@Nullable @BsonProperty(value="removedFields") List<String> list, @Nullable @BsonProperty(value="updatedFields") BsonDocument bsonDocument, @Nullable @BsonProperty(value="truncatedArrays") List<TruncatedArray> list2, @Nullable @BsonProperty(value="disambiguatedPaths") BsonDocument bsonDocument2) {
        this.removedFields = list;
        this.updatedFields = bsonDocument;
        this.truncatedArrays = list2 == null ? Collections.emptyList() : list2;
        this.disambiguatedPaths = bsonDocument2;
    }

    @Nullable
    public List<String> getRemovedFields() {
        return this.removedFields;
    }

    @Nullable
    public BsonDocument getUpdatedFields() {
        return this.updatedFields;
    }

    @NonNull
    public List<TruncatedArray> getTruncatedArrays() {
        return this.truncatedArrays;
    }

    @Nullable
    public BsonDocument getDisambiguatedPaths() {
        return this.disambiguatedPaths;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        UpdateDescription updateDescription = (UpdateDescription)object;
        return Objects.equals(this.removedFields, updateDescription.removedFields) && Objects.equals(this.updatedFields, updateDescription.updatedFields) && Objects.equals(this.truncatedArrays, updateDescription.truncatedArrays) && Objects.equals(this.disambiguatedPaths, updateDescription.disambiguatedPaths);
    }

    public int hashCode() {
        return Objects.hash(this.removedFields, this.updatedFields, this.truncatedArrays, this.disambiguatedPaths);
    }

    public String toString() {
        return "UpdateDescription{removedFields=" + this.removedFields + ", updatedFields=" + this.updatedFields + ", truncatedArrays=" + this.truncatedArrays + ", disambiguatedPaths=" + this.disambiguatedPaths + "}";
    }
}

