/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.densify;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.densify.DateDensifyRange;
import com.mongodb.client.model.densify.DensifyOptions;
import com.mongodb.client.model.densify.NumberDensifyRange;
import com.mongodb.internal.client.model.AbstractConstructibleBson;
import com.mongodb.internal.client.model.Util;
import org.bson.Document;
import org.bson.conversions.Bson;

final class DensifyConstructibleBson
extends AbstractConstructibleBson<DensifyConstructibleBson>
implements NumberDensifyRange,
DateDensifyRange,
DensifyOptions {
    static final DensifyConstructibleBson EMPTY_IMMUTABLE = new DensifyConstructibleBson(AbstractConstructibleBson.EMPTY_IMMUTABLE);

    DensifyConstructibleBson(Bson bson) {
        super(bson);
    }

    private DensifyConstructibleBson(Bson bson, Document document) {
        super(bson, document);
    }

    @Override
    protected DensifyConstructibleBson newSelf(Bson bson, Document document) {
        return new DensifyConstructibleBson(bson, document);
    }

    @Override
    public DensifyOptions partitionByFields(Iterable<String> iterable) {
        Assertions.notNull("partitionByFields", iterable);
        return (DensifyOptions)this.newMutated(document -> {
            if (Util.sizeAtLeast(iterable, 1)) {
                document.append("partitionByFields", iterable);
            } else {
                document.remove("partitionByFields");
            }
        });
    }

    @Override
    public DensifyOptions option(String string, Object object) {
        return (DensifyOptions)this.newAppended(Assertions.notNull("name", string), Assertions.notNull("value", object));
    }
}

