/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.densify;

import com.mongodb.annotations.Evolving;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.MongoTimeUnit;
import com.mongodb.client.model.densify.DateDensifyRange;
import com.mongodb.client.model.densify.DensifyConstructibleBson;
import com.mongodb.client.model.densify.NumberDensifyRange;
import java.time.Instant;
import java.util.Arrays;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.Document;
import org.bson.conversions.Bson;

@Evolving
public interface DensifyRange
extends Bson {
    public static NumberDensifyRange fullRangeWithStep(Number number) {
        return new DensifyConstructibleBson(new Document("bounds", "full").append("step", Assertions.notNull("step", number)));
    }

    public static NumberDensifyRange partitionRangeWithStep(Number number) {
        return new DensifyConstructibleBson(new Document("bounds", "partition").append("step", Assertions.notNull("step", number)));
    }

    public static NumberDensifyRange rangeWithStep(Number number, Number number2, Number number3) {
        Assertions.notNull("l", number);
        Assertions.notNull("u", number2);
        Assertions.notNull("step", number3);
        return new DensifyConstructibleBson(new Document("bounds", Arrays.asList(number, number2)).append("step", Assertions.notNull("step", number3)));
    }

    public static DateDensifyRange fullRangeWithStep(long l, MongoTimeUnit mongoTimeUnit) {
        Assertions.notNull("unit", mongoTimeUnit);
        return new DensifyConstructibleBson(new BsonDocument("bounds", new BsonString("full")).append("step", new BsonInt64(l)).append("unit", new BsonString(mongoTimeUnit.value())));
    }

    public static DateDensifyRange partitionRangeWithStep(long l, MongoTimeUnit mongoTimeUnit) {
        Assertions.notNull("unit", mongoTimeUnit);
        return new DensifyConstructibleBson(new BsonDocument("bounds", new BsonString("partition")).append("step", new BsonInt64(l)).append("unit", new BsonString(mongoTimeUnit.value())));
    }

    public static DateDensifyRange rangeWithStep(Instant instant, Instant instant2, long l, MongoTimeUnit mongoTimeUnit) {
        Assertions.notNull("l", instant);
        Assertions.notNull("u", instant2);
        Assertions.notNull("unit", mongoTimeUnit);
        return new DensifyConstructibleBson(new Document("bounds", Arrays.asList(instant, instant2)).append("step", l).append("unit", mongoTimeUnit.value()));
    }

    public static DensifyRange of(Bson bson) {
        return new DensifyConstructibleBson(Assertions.notNull("range", bson));
    }
}

