/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.fill;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.fill.FillOptions;
import com.mongodb.internal.client.model.AbstractConstructibleBson;
import com.mongodb.internal.client.model.Util;
import org.bson.Document;
import org.bson.conversions.Bson;

final class FillConstructibleBson
extends AbstractConstructibleBson<FillConstructibleBson>
implements FillOptions {
    static final FillConstructibleBson EMPTY_IMMUTABLE = new FillConstructibleBson(AbstractConstructibleBson.EMPTY_IMMUTABLE);

    FillConstructibleBson(Bson bson) {
        super(bson);
    }

    private FillConstructibleBson(Bson bson, Document document) {
        super(bson, document);
    }

    @Override
    protected FillConstructibleBson newSelf(Bson bson, Document document) {
        return new FillConstructibleBson(bson, document);
    }

    @Override
    public <TExpression> FillOptions partitionBy(TExpression TExpression) {
        Assertions.notNull("expression", TExpression);
        return (FillOptions)this.newMutated(document -> {
            document.remove("partitionByFields");
            document.append("partitionBy", TExpression);
        });
    }

    @Override
    public FillOptions partitionByFields(Iterable<String> iterable) {
        Assertions.notNull("fields", iterable);
        return (FillOptions)this.newMutated(document -> {
            document.remove("partitionBy");
            if (Util.sizeAtLeast(iterable, 1)) {
                document.append("partitionByFields", iterable);
            } else {
                document.remove("partitionByFields");
            }
        });
    }

    @Override
    public FillOptions sortBy(Bson bson) {
        return (FillOptions)this.newAppended("sortBy", Assertions.notNull("sortBy", bson));
    }

    @Override
    public FillOptions option(String string, Object object) {
        return (FillOptions)this.newAppended(Assertions.notNull("name", string), Assertions.notNull("value", object));
    }
}

