/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.mongodb.client.model.geojson.GeoJsonObjectType;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;

public final class GeometryCollection
extends Geometry {
    private final List<? extends Geometry> geometries;

    public GeometryCollection(List<? extends Geometry> list) {
        this(null, list);
    }

    public GeometryCollection(@Nullable CoordinateReferenceSystem coordinateReferenceSystem, List<? extends Geometry> list) {
        super(coordinateReferenceSystem);
        Assertions.notNull("geometries", list);
        Assertions.doesNotContainNull("geometries", list);
        this.geometries = Collections.unmodifiableList(list);
    }

    @Override
    public GeoJsonObjectType getType() {
        return GeoJsonObjectType.GEOMETRY_COLLECTION;
    }

    public List<? extends Geometry> getGeometries() {
        return this.geometries;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        GeometryCollection geometryCollection = (GeometryCollection)object;
        return this.geometries.equals(geometryCollection.geometries);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.geometries.hashCode();
        return n;
    }

    public String toString() {
        CoordinateReferenceSystem coordinateReferenceSystem = this.getCoordinateReferenceSystem();
        return "GeometryCollection{geometries=" + this.geometries + (coordinateReferenceSystem == null ? "" : ", coordinateReferenceSystem=" + coordinateReferenceSystem) + '}';
    }
}

