/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.mongodb.client.model.geojson.GeoJsonObjectType;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.Position;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;

public final class MultiLineString
extends Geometry {
    private final List<List<Position>> coordinates;

    public MultiLineString(List<List<Position>> list) {
        this(null, list);
    }

    public MultiLineString(@Nullable CoordinateReferenceSystem coordinateReferenceSystem, List<List<Position>> list) {
        super(coordinateReferenceSystem);
        Assertions.notNull("coordinates", list);
        for (List<Position> list2 : list) {
            Assertions.notNull("line", list2);
            Assertions.doesNotContainNull("line", list2);
        }
        this.coordinates = Collections.unmodifiableList(list);
    }

    @Override
    public GeoJsonObjectType getType() {
        return GeoJsonObjectType.MULTI_LINE_STRING;
    }

    public List<List<Position>> getCoordinates() {
        return this.coordinates;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MultiLineString multiLineString = (MultiLineString)object;
        return this.coordinates.equals(multiLineString.coordinates);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.coordinates.hashCode();
        return n;
    }

    public String toString() {
        return "MultiLineString{coordinates=" + this.coordinates + (this.getCoordinateReferenceSystem() == null ? "" : ", coordinateReferenceSystem=" + this.getCoordinateReferenceSystem()) + '}';
    }
}

