/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.mongodb.client.model.geojson.GeoJsonObjectType;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.Position;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;

public final class MultiPoint
extends Geometry {
    private final List<Position> coordinates;

    public MultiPoint(List<Position> list) {
        this(null, list);
    }

    public MultiPoint(@Nullable CoordinateReferenceSystem coordinateReferenceSystem, List<Position> list) {
        super(coordinateReferenceSystem);
        Assertions.notNull("coordinates", list);
        Assertions.isTrueArgument("coordinates contains only non-null positions", !list.contains(null));
        this.coordinates = Collections.unmodifiableList(list);
    }

    @Override
    public GeoJsonObjectType getType() {
        return GeoJsonObjectType.MULTI_POINT;
    }

    public List<Position> getCoordinates() {
        return this.coordinates;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MultiPoint multiPoint = (MultiPoint)object;
        return this.coordinates.equals(multiPoint.coordinates);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        return 31 * n + this.coordinates.hashCode();
    }

    public String toString() {
        return "MultiPoint{coordinates=" + this.coordinates + (this.getCoordinateReferenceSystem() == null ? "" : ", coordinateReferenceSystem=" + this.getCoordinateReferenceSystem()) + '}';
    }
}

