/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.mongodb.client.model.geojson.GeoJsonObjectType;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.PolygonCoordinates;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;

public final class MultiPolygon
extends Geometry {
    private final List<PolygonCoordinates> coordinates;

    public MultiPolygon(List<PolygonCoordinates> list) {
        this(null, list);
    }

    public MultiPolygon(@Nullable CoordinateReferenceSystem coordinateReferenceSystem, List<PolygonCoordinates> list) {
        super(coordinateReferenceSystem);
        Assertions.notNull("coordinates", list);
        Assertions.doesNotContainNull("coordinates", list);
        this.coordinates = Collections.unmodifiableList(list);
    }

    @Override
    public GeoJsonObjectType getType() {
        return GeoJsonObjectType.MULTI_POLYGON;
    }

    public List<PolygonCoordinates> getCoordinates() {
        return this.coordinates;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MultiPolygon multiPolygon = (MultiPolygon)object;
        return this.coordinates.equals(multiPolygon.coordinates);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.coordinates.hashCode();
        return n;
    }

    public String toString() {
        return "MultiPolygon{coordinates=" + this.coordinates + (this.getCoordinateReferenceSystem() == null ? "" : ", coordinateReferenceSystem=" + this.getCoordinateReferenceSystem()) + '}';
    }
}

