/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.mongodb.client.model.geojson.GeoJsonObjectType;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.Position;
import com.mongodb.lang.Nullable;

public final class Point
extends Geometry {
    private final Position coordinate;

    public Point(Position position) {
        this(null, position);
    }

    public Point(@Nullable CoordinateReferenceSystem coordinateReferenceSystem, Position position) {
        super(coordinateReferenceSystem);
        this.coordinate = Assertions.notNull("coordinates", position);
    }

    @Override
    public GeoJsonObjectType getType() {
        return GeoJsonObjectType.POINT;
    }

    public Position getCoordinates() {
        return this.coordinate;
    }

    public Position getPosition() {
        return this.coordinate;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Point point = (Point)object;
        return this.coordinate.equals(point.coordinate);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        return 31 * n + this.coordinate.hashCode();
    }

    public String toString() {
        return "Point{coordinate=" + this.coordinate + (this.getCoordinateReferenceSystem() == null ? "" : ", coordinateReferenceSystem=" + this.getCoordinateReferenceSystem()) + '}';
    }
}

