/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.mongodb.client.model.geojson.GeoJsonObjectType;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.PolygonCoordinates;
import com.mongodb.client.model.geojson.Position;
import com.mongodb.lang.Nullable;
import java.util.List;

public final class Polygon
extends Geometry {
    private final PolygonCoordinates coordinates;

    @SafeVarargs
    public Polygon(List<Position> list, List<Position> ... listArray) {
        this(new PolygonCoordinates(list, listArray));
    }

    public Polygon(List<Position> list, List<List<Position>> list2) {
        this(new PolygonCoordinates(list, list2));
    }

    public Polygon(PolygonCoordinates polygonCoordinates) {
        this(null, polygonCoordinates);
    }

    public Polygon(@Nullable CoordinateReferenceSystem coordinateReferenceSystem, PolygonCoordinates polygonCoordinates) {
        super(coordinateReferenceSystem);
        this.coordinates = Assertions.notNull("coordinates", polygonCoordinates);
    }

    @Override
    public GeoJsonObjectType getType() {
        return GeoJsonObjectType.POLYGON;
    }

    public PolygonCoordinates getCoordinates() {
        return this.coordinates;
    }

    public List<Position> getExterior() {
        return this.coordinates.getExterior();
    }

    public List<List<Position>> getHoles() {
        return this.coordinates.getHoles();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Polygon polygon = (Polygon)object;
        return this.coordinates.equals(polygon.coordinates);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.coordinates.hashCode();
        return n;
    }

    public String toString() {
        return "Polygon{exterior=" + this.coordinates.getExterior() + (this.coordinates.getHoles().isEmpty() ? "" : ", holes=" + this.coordinates.getHoles()) + (this.getCoordinateReferenceSystem() == null ? "" : ", coordinateReferenceSystem=" + this.getCoordinateReferenceSystem()) + '}';
    }
}

