/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.Position;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class PolygonCoordinates {
    private final List<Position> exterior;
    private final List<List<Position>> holes;

    @SafeVarargs
    public PolygonCoordinates(List<Position> list, List<Position> ... listArray) {
        this(list, Arrays.asList(listArray));
    }

    public PolygonCoordinates(List<Position> list, List<List<Position>> list2) {
        Assertions.notNull("exteriorRing", list);
        Assertions.doesNotContainNull("exterior", list);
        Assertions.isTrueArgument("ring must contain at least four positions", list.size() >= 4);
        Assertions.isTrueArgument("first and last position must be the same", list.get(0).equals(list.get(list.size() - 1)));
        this.exterior = Collections.unmodifiableList(list);
        ArrayList<List<Position>> arrayList = new ArrayList<List<Position>>(list2.size());
        for (List<Position> list3 : list2) {
            Assertions.notNull("interiorRing", list3);
            Assertions.doesNotContainNull("hole", list3);
            Assertions.isTrueArgument("ring must contain at least four positions", list3.size() >= 4);
            Assertions.isTrueArgument("first and last position must be the same", list3.get(0).equals(list3.get(list3.size() - 1)));
            arrayList.add(Collections.unmodifiableList(list3));
        }
        this.holes = Collections.unmodifiableList(arrayList);
    }

    public List<Position> getExterior() {
        return this.exterior;
    }

    public List<List<Position>> getHoles() {
        return this.holes;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PolygonCoordinates polygonCoordinates = (PolygonCoordinates)object;
        if (!this.exterior.equals(polygonCoordinates.exterior)) {
            return false;
        }
        return this.holes.equals(polygonCoordinates.holes);
    }

    public int hashCode() {
        int n = this.exterior.hashCode();
        n = 31 * n + this.holes.hashCode();
        return n;
    }

    public String toString() {
        return "PolygonCoordinates{exterior=" + this.exterior + (this.holes.isEmpty() ? "" : ", holes=" + this.holes) + '}';
    }
}

