/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson;

import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Immutable
public final class Position {
    private final List<Double> values;

    public Position(List<Double> list) {
        Assertions.notNull("values", list);
        Assertions.doesNotContainNull("values", list);
        Assertions.isTrueArgument("value must contain at least two elements", list.size() >= 2);
        this.values = Collections.unmodifiableList(list);
    }

    public Position(double d, double d2, double ... dArray) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(d);
        arrayList.add(d2);
        for (double d3 : dArray) {
            arrayList.add(d3);
        }
        this.values = Collections.unmodifiableList(arrayList);
    }

    public List<Double> getValues() {
        return this.values;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Position position = (Position)object;
        return this.values.equals(position.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return "Position{values=" + this.values + '}';
    }
}

