/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson.codecs;

import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.codecs.GeometryDecoderHelper;
import com.mongodb.client.model.geojson.codecs.GeometryEncoderHelper;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

abstract class AbstractGeometryCodec<T extends Geometry>
implements Codec<T> {
    private final CodecRegistry registry;
    private final Class<T> encoderClass;

    AbstractGeometryCodec(CodecRegistry codecRegistry, Class<T> clazz) {
        this.registry = codecRegistry;
        this.encoderClass = clazz;
    }

    @Override
    public void encode(BsonWriter bsonWriter, T t, EncoderContext encoderContext) {
        GeometryEncoderHelper.encodeGeometry(bsonWriter, t, encoderContext, this.registry);
    }

    @Override
    public T decode(BsonReader bsonReader, DecoderContext decoderContext) {
        return GeometryDecoderHelper.decodeGeometry(bsonReader, this.getEncoderClass());
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.encoderClass;
    }
}

