/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson.codecs;

import com.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.GeometryCollection;
import com.mongodb.client.model.geojson.LineString;
import com.mongodb.client.model.geojson.MultiLineString;
import com.mongodb.client.model.geojson.MultiPoint;
import com.mongodb.client.model.geojson.MultiPolygon;
import com.mongodb.client.model.geojson.NamedCoordinateReferenceSystem;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.model.geojson.Polygon;
import com.mongodb.client.model.geojson.PolygonCoordinates;
import com.mongodb.client.model.geojson.Position;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonReader;
import org.bson.BsonReaderMark;
import org.bson.BsonType;
import org.bson.codecs.configuration.CodecConfigurationException;

final class GeometryDecoderHelper {
    static <T extends Geometry> T decodeGeometry(BsonReader bsonReader, Class<T> clazz) {
        if (clazz.equals(Point.class)) {
            return (T)GeometryDecoderHelper.decodePoint(bsonReader);
        }
        if (clazz.equals(MultiPoint.class)) {
            return (T)GeometryDecoderHelper.decodeMultiPoint(bsonReader);
        }
        if (clazz.equals(Polygon.class)) {
            return (T)GeometryDecoderHelper.decodePolygon(bsonReader);
        }
        if (clazz.equals(MultiPolygon.class)) {
            return (T)GeometryDecoderHelper.decodeMultiPolygon(bsonReader);
        }
        if (clazz.equals(LineString.class)) {
            return (T)GeometryDecoderHelper.decodeLineString(bsonReader);
        }
        if (clazz.equals(MultiLineString.class)) {
            return (T)GeometryDecoderHelper.decodeMultiLineString(bsonReader);
        }
        if (clazz.equals(GeometryCollection.class)) {
            return (T)GeometryDecoderHelper.decodeGeometryCollection(bsonReader);
        }
        if (clazz.equals(Geometry.class)) {
            return (T)GeometryDecoderHelper.decodeGeometry(bsonReader);
        }
        throw new CodecConfigurationException(String.format("Unsupported Geometry: %s", clazz));
    }

    private static Point decodePoint(BsonReader bsonReader) {
        String string = null;
        Position position = null;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string2 = bsonReader.readName();
            if (string2.equals("type")) {
                string = bsonReader.readString();
                continue;
            }
            if (string2.equals("coordinates")) {
                position = GeometryDecoderHelper.decodePosition(bsonReader);
                continue;
            }
            if (string2.equals("crs")) {
                coordinateReferenceSystem = GeometryDecoderHelper.decodeCoordinateReferenceSystem(bsonReader);
                continue;
            }
            throw new CodecConfigurationException(String.format("Unexpected key '%s' found when decoding a GeoJSON point", string2));
        }
        bsonReader.readEndDocument();
        if (string == null) {
            throw new CodecConfigurationException("Invalid Point, document contained no type information.");
        }
        if (!string.equals("Point")) {
            throw new CodecConfigurationException(String.format("Invalid Point, found type '%s'.", string));
        }
        if (position == null) {
            throw new CodecConfigurationException("Invalid Point, missing position coordinates.");
        }
        return coordinateReferenceSystem != null ? new Point(coordinateReferenceSystem, position) : new Point(position);
    }

    private static MultiPoint decodeMultiPoint(BsonReader bsonReader) {
        String string = null;
        List<Position> list = null;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string2 = bsonReader.readName();
            if (string2.equals("type")) {
                string = bsonReader.readString();
                continue;
            }
            if (string2.equals("coordinates")) {
                list = GeometryDecoderHelper.decodeCoordinates(bsonReader);
                continue;
            }
            if (string2.equals("crs")) {
                coordinateReferenceSystem = GeometryDecoderHelper.decodeCoordinateReferenceSystem(bsonReader);
                continue;
            }
            throw new CodecConfigurationException(String.format("Unexpected key '%s' found when decoding a GeoJSON point", string2));
        }
        bsonReader.readEndDocument();
        if (string == null) {
            throw new CodecConfigurationException("Invalid MultiPoint, document contained no type information.");
        }
        if (!string.equals("MultiPoint")) {
            throw new CodecConfigurationException(String.format("Invalid MultiPoint, found type '%s'.", string));
        }
        if (list == null) {
            throw new CodecConfigurationException("Invalid MultiPoint, missing position coordinates.");
        }
        return coordinateReferenceSystem != null ? new MultiPoint(coordinateReferenceSystem, list) : new MultiPoint(list);
    }

    private static Polygon decodePolygon(BsonReader bsonReader) {
        String string = null;
        PolygonCoordinates polygonCoordinates = null;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string2 = bsonReader.readName();
            if (string2.equals("type")) {
                string = bsonReader.readString();
                continue;
            }
            if (string2.equals("coordinates")) {
                polygonCoordinates = GeometryDecoderHelper.decodePolygonCoordinates(bsonReader);
                continue;
            }
            if (string2.equals("crs")) {
                coordinateReferenceSystem = GeometryDecoderHelper.decodeCoordinateReferenceSystem(bsonReader);
                continue;
            }
            throw new CodecConfigurationException(String.format("Unexpected key '%s' found when decoding a GeoJSON Polygon", string2));
        }
        bsonReader.readEndDocument();
        if (string == null) {
            throw new CodecConfigurationException("Invalid Polygon, document contained no type information.");
        }
        if (!string.equals("Polygon")) {
            throw new CodecConfigurationException(String.format("Invalid Polygon, found type '%s'.", string));
        }
        if (polygonCoordinates == null) {
            throw new CodecConfigurationException("Invalid Polygon, missing coordinates.");
        }
        return coordinateReferenceSystem != null ? new Polygon(coordinateReferenceSystem, polygonCoordinates) : new Polygon(polygonCoordinates);
    }

    private static MultiPolygon decodeMultiPolygon(BsonReader bsonReader) {
        String string = null;
        List<PolygonCoordinates> list = null;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string2 = bsonReader.readName();
            if (string2.equals("type")) {
                string = bsonReader.readString();
                continue;
            }
            if (string2.equals("coordinates")) {
                list = GeometryDecoderHelper.decodeMultiPolygonCoordinates(bsonReader);
                continue;
            }
            if (string2.equals("crs")) {
                coordinateReferenceSystem = GeometryDecoderHelper.decodeCoordinateReferenceSystem(bsonReader);
                continue;
            }
            throw new CodecConfigurationException(String.format("Unexpected key '%s' found when decoding a GeoJSON Polygon", string2));
        }
        bsonReader.readEndDocument();
        if (string == null) {
            throw new CodecConfigurationException("Invalid MultiPolygon, document contained no type information.");
        }
        if (!string.equals("MultiPolygon")) {
            throw new CodecConfigurationException(String.format("Invalid MultiPolygon, found type '%s'.", string));
        }
        if (list == null) {
            throw new CodecConfigurationException("Invalid MultiPolygon, missing coordinates.");
        }
        return coordinateReferenceSystem != null ? new MultiPolygon(coordinateReferenceSystem, list) : new MultiPolygon(list);
    }

    private static LineString decodeLineString(BsonReader bsonReader) {
        String string = null;
        List<Position> list = null;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string2 = bsonReader.readName();
            if (string2.equals("type")) {
                string = bsonReader.readString();
                continue;
            }
            if (string2.equals("coordinates")) {
                list = GeometryDecoderHelper.decodeCoordinates(bsonReader);
                continue;
            }
            if (string2.equals("crs")) {
                coordinateReferenceSystem = GeometryDecoderHelper.decodeCoordinateReferenceSystem(bsonReader);
                continue;
            }
            throw new CodecConfigurationException(String.format("Unexpected key '%s' found when decoding a GeoJSON Polygon", string2));
        }
        bsonReader.readEndDocument();
        if (string == null) {
            throw new CodecConfigurationException("Invalid LineString, document contained no type information.");
        }
        if (!string.equals("LineString")) {
            throw new CodecConfigurationException(String.format("Invalid LineString, found type '%s'.", string));
        }
        if (list == null) {
            throw new CodecConfigurationException("Invalid LineString, missing coordinates.");
        }
        return coordinateReferenceSystem != null ? new LineString(coordinateReferenceSystem, list) : new LineString(list);
    }

    private static MultiLineString decodeMultiLineString(BsonReader bsonReader) {
        String string = null;
        List<List<Position>> list = null;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string2 = bsonReader.readName();
            if (string2.equals("type")) {
                string = bsonReader.readString();
                continue;
            }
            if (string2.equals("coordinates")) {
                list = GeometryDecoderHelper.decodeMultiCoordinates(bsonReader);
                continue;
            }
            if (string2.equals("crs")) {
                coordinateReferenceSystem = GeometryDecoderHelper.decodeCoordinateReferenceSystem(bsonReader);
                continue;
            }
            throw new CodecConfigurationException(String.format("Unexpected key '%s' found when decoding a GeoJSON Polygon", string2));
        }
        bsonReader.readEndDocument();
        if (string == null) {
            throw new CodecConfigurationException("Invalid MultiLineString, document contained no type information.");
        }
        if (!string.equals("MultiLineString")) {
            throw new CodecConfigurationException(String.format("Invalid MultiLineString, found type '%s'.", string));
        }
        if (list == null) {
            throw new CodecConfigurationException("Invalid MultiLineString, missing coordinates.");
        }
        return coordinateReferenceSystem != null ? new MultiLineString(coordinateReferenceSystem, list) : new MultiLineString(list);
    }

    private static GeometryCollection decodeGeometryCollection(BsonReader bsonReader) {
        String string = null;
        List<? extends Geometry> list = null;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string2 = bsonReader.readName();
            if (string2.equals("type")) {
                string = bsonReader.readString();
                continue;
            }
            if (string2.equals("geometries")) {
                list = GeometryDecoderHelper.decodeGeometries(bsonReader);
                continue;
            }
            if (string2.equals("crs")) {
                coordinateReferenceSystem = GeometryDecoderHelper.decodeCoordinateReferenceSystem(bsonReader);
                continue;
            }
            throw new CodecConfigurationException(String.format("Unexpected key '%s' found when decoding a GeoJSON Polygon", string2));
        }
        bsonReader.readEndDocument();
        if (string == null) {
            throw new CodecConfigurationException("Invalid GeometryCollection, document contained no type information.");
        }
        if (!string.equals("GeometryCollection")) {
            throw new CodecConfigurationException(String.format("Invalid GeometryCollection, found type '%s'.", string));
        }
        if (list == null) {
            throw new CodecConfigurationException("Invalid GeometryCollection, missing geometries.");
        }
        return coordinateReferenceSystem != null ? new GeometryCollection(coordinateReferenceSystem, list) : new GeometryCollection(list);
    }

    private static List<? extends Geometry> decodeGeometries(BsonReader bsonReader) {
        GeometryDecoderHelper.validateIsArray(bsonReader);
        bsonReader.readStartArray();
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            Geometry geometry = GeometryDecoderHelper.decodeGeometry(bsonReader);
            arrayList.add(geometry);
        }
        bsonReader.readEndArray();
        return arrayList;
    }

    private static Geometry decodeGeometry(BsonReader bsonReader) {
        Object object;
        String string = null;
        BsonReaderMark bsonReaderMark = bsonReader.getMark();
        GeometryDecoderHelper.validateIsDocument(bsonReader);
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            object = bsonReader.readName();
            if (((String)object).equals("type")) {
                string = bsonReader.readString();
                break;
            }
            bsonReader.skipValue();
        }
        bsonReaderMark.reset();
        if (string == null) {
            throw new CodecConfigurationException("Invalid Geometry item, document contained no type information.");
        }
        object = null;
        if (string.equals("Point")) {
            object = GeometryDecoderHelper.decodePoint(bsonReader);
        } else if (string.equals("MultiPoint")) {
            object = GeometryDecoderHelper.decodeMultiPoint(bsonReader);
        } else if (string.equals("Polygon")) {
            object = GeometryDecoderHelper.decodePolygon(bsonReader);
        } else if (string.equals("MultiPolygon")) {
            object = GeometryDecoderHelper.decodeMultiPolygon(bsonReader);
        } else if (string.equals("LineString")) {
            object = GeometryDecoderHelper.decodeLineString(bsonReader);
        } else if (string.equals("MultiLineString")) {
            object = GeometryDecoderHelper.decodeMultiLineString(bsonReader);
        } else if (string.equals("GeometryCollection")) {
            object = GeometryDecoderHelper.decodeGeometryCollection(bsonReader);
        } else {
            throw new CodecConfigurationException(String.format("Invalid Geometry item, found type '%s'.", string));
        }
        return object;
    }

    private static PolygonCoordinates decodePolygonCoordinates(BsonReader bsonReader) {
        GeometryDecoderHelper.validateIsArray(bsonReader);
        bsonReader.readStartArray();
        ArrayList<List<Position>> arrayList = new ArrayList<List<Position>>();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            arrayList.add(GeometryDecoderHelper.decodeCoordinates(bsonReader));
        }
        bsonReader.readEndArray();
        if (arrayList.isEmpty()) {
            throw new CodecConfigurationException("Invalid Polygon no coordinates.");
        }
        List list = (List)arrayList.remove(0);
        ArrayList[] arrayListArray = arrayList.toArray(new ArrayList[arrayList.size()]);
        try {
            return new PolygonCoordinates((List<Position>)list, arrayListArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CodecConfigurationException(String.format("Invalid Polygon: %s", illegalArgumentException.getMessage()));
        }
    }

    private static List<PolygonCoordinates> decodeMultiPolygonCoordinates(BsonReader bsonReader) {
        GeometryDecoderHelper.validateIsArray(bsonReader);
        bsonReader.readStartArray();
        ArrayList<PolygonCoordinates> arrayList = new ArrayList<PolygonCoordinates>();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            arrayList.add(GeometryDecoderHelper.decodePolygonCoordinates(bsonReader));
        }
        bsonReader.readEndArray();
        if (arrayList.isEmpty()) {
            throw new CodecConfigurationException("Invalid MultiPolygon no coordinates.");
        }
        return arrayList;
    }

    private static List<Position> decodeCoordinates(BsonReader bsonReader) {
        GeometryDecoderHelper.validateIsArray(bsonReader);
        bsonReader.readStartArray();
        ArrayList<Position> arrayList = new ArrayList<Position>();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            arrayList.add(GeometryDecoderHelper.decodePosition(bsonReader));
        }
        bsonReader.readEndArray();
        return arrayList;
    }

    private static List<List<Position>> decodeMultiCoordinates(BsonReader bsonReader) {
        GeometryDecoderHelper.validateIsArray(bsonReader);
        bsonReader.readStartArray();
        ArrayList<List<Position>> arrayList = new ArrayList<List<Position>>();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            arrayList.add(GeometryDecoderHelper.decodeCoordinates(bsonReader));
        }
        bsonReader.readEndArray();
        return arrayList;
    }

    private static Position decodePosition(BsonReader bsonReader) {
        GeometryDecoderHelper.validateIsArray(bsonReader);
        bsonReader.readStartArray();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            arrayList.add(GeometryDecoderHelper.readAsDouble(bsonReader));
        }
        bsonReader.readEndArray();
        try {
            return new Position(arrayList);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CodecConfigurationException(String.format("Invalid Position: %s", illegalArgumentException.getMessage()));
        }
    }

    private static double readAsDouble(BsonReader bsonReader) {
        if (bsonReader.getCurrentBsonType() == BsonType.DOUBLE) {
            return bsonReader.readDouble();
        }
        if (bsonReader.getCurrentBsonType() == BsonType.INT32) {
            return bsonReader.readInt32();
        }
        if (bsonReader.getCurrentBsonType() == BsonType.INT64) {
            return bsonReader.readInt64();
        }
        throw new CodecConfigurationException("A GeoJSON position value must be a numerical type, but the value is of type " + (Object)((Object)bsonReader.getCurrentBsonType()));
    }

    @Nullable
    static CoordinateReferenceSystem decodeCoordinateReferenceSystem(BsonReader bsonReader) {
        String string = null;
        GeometryDecoderHelper.validateIsDocument(bsonReader);
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string2 = bsonReader.readName();
            if (string2.equals("type")) {
                String string3 = bsonReader.readString();
                if (string3.equals("name")) continue;
                throw new CodecConfigurationException(String.format("Unsupported CoordinateReferenceSystem '%s'.", string3));
            }
            if (string2.equals("properties")) {
                string = GeometryDecoderHelper.decodeCoordinateReferenceSystemProperties(bsonReader);
                continue;
            }
            throw new CodecConfigurationException(String.format("Found invalid key '%s' in the CoordinateReferenceSystem.", string2));
        }
        bsonReader.readEndDocument();
        return string != null ? new NamedCoordinateReferenceSystem(string) : null;
    }

    private static String decodeCoordinateReferenceSystemProperties(BsonReader bsonReader) {
        String string = null;
        GeometryDecoderHelper.validateIsDocument(bsonReader);
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String string2 = bsonReader.readName();
            if (string2.equals("name")) {
                string = bsonReader.readString();
                continue;
            }
            throw new CodecConfigurationException(String.format("Found invalid key '%s' in the CoordinateReferenceSystem.", string2));
        }
        bsonReader.readEndDocument();
        if (string == null) {
            throw new CodecConfigurationException("Found invalid properties in the CoordinateReferenceSystem.");
        }
        return string;
    }

    private static void validateIsDocument(BsonReader bsonReader) {
        BsonType bsonType = bsonReader.getCurrentBsonType();
        if (bsonType == null) {
            bsonType = bsonReader.readBsonType();
        }
        if (!bsonType.equals((Object)BsonType.DOCUMENT)) {
            throw new CodecConfigurationException("Invalid BsonType expecting a Document");
        }
    }

    private static void validateIsArray(BsonReader bsonReader) {
        if (bsonReader.getCurrentBsonType() != BsonType.ARRAY) {
            throw new CodecConfigurationException("Invalid BsonType expecting an Array");
        }
    }

    private GeometryDecoderHelper() {
    }
}

