/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson.codecs;

import com.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.GeometryCollection;
import com.mongodb.client.model.geojson.LineString;
import com.mongodb.client.model.geojson.MultiLineString;
import com.mongodb.client.model.geojson.MultiPoint;
import com.mongodb.client.model.geojson.MultiPolygon;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.model.geojson.Polygon;
import com.mongodb.client.model.geojson.PolygonCoordinates;
import com.mongodb.client.model.geojson.Position;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;

final class GeometryEncoderHelper {
    static void encodeGeometry(BsonWriter bsonWriter, Geometry geometry, EncoderContext encoderContext, CodecRegistry codecRegistry) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeString("type", geometry.getType().getTypeName());
        if (geometry instanceof GeometryCollection) {
            bsonWriter.writeName("geometries");
            GeometryEncoderHelper.encodeGeometryCollection(bsonWriter, (GeometryCollection)geometry, encoderContext, codecRegistry);
        } else {
            bsonWriter.writeName("coordinates");
            if (geometry instanceof Point) {
                GeometryEncoderHelper.encodePoint(bsonWriter, (Point)geometry);
            } else if (geometry instanceof MultiPoint) {
                GeometryEncoderHelper.encodeMultiPoint(bsonWriter, (MultiPoint)geometry);
            } else if (geometry instanceof Polygon) {
                GeometryEncoderHelper.encodePolygon(bsonWriter, (Polygon)geometry);
            } else if (geometry instanceof MultiPolygon) {
                GeometryEncoderHelper.encodeMultiPolygon(bsonWriter, (MultiPolygon)geometry);
            } else if (geometry instanceof LineString) {
                GeometryEncoderHelper.encodeLineString(bsonWriter, (LineString)geometry);
            } else if (geometry instanceof MultiLineString) {
                GeometryEncoderHelper.encodeMultiLineString(bsonWriter, (MultiLineString)geometry);
            } else {
                throw new CodecConfigurationException(String.format("Unsupported Geometry: %s", geometry));
            }
        }
        GeometryEncoderHelper.encodeCoordinateReferenceSystem(bsonWriter, geometry, encoderContext, codecRegistry);
        bsonWriter.writeEndDocument();
    }

    private static void encodePoint(BsonWriter bsonWriter, Point point) {
        GeometryEncoderHelper.encodePosition(bsonWriter, point.getPosition());
    }

    private static void encodeMultiPoint(BsonWriter bsonWriter, MultiPoint multiPoint) {
        bsonWriter.writeStartArray();
        for (Position position : multiPoint.getCoordinates()) {
            GeometryEncoderHelper.encodePosition(bsonWriter, position);
        }
        bsonWriter.writeEndArray();
    }

    private static void encodePolygon(BsonWriter bsonWriter, Polygon polygon) {
        GeometryEncoderHelper.encodePolygonCoordinates(bsonWriter, polygon.getCoordinates());
    }

    private static void encodeMultiPolygon(BsonWriter bsonWriter, MultiPolygon multiPolygon) {
        bsonWriter.writeStartArray();
        for (PolygonCoordinates polygonCoordinates : multiPolygon.getCoordinates()) {
            GeometryEncoderHelper.encodePolygonCoordinates(bsonWriter, polygonCoordinates);
        }
        bsonWriter.writeEndArray();
    }

    private static void encodeLineString(BsonWriter bsonWriter, LineString lineString) {
        bsonWriter.writeStartArray();
        for (Position position : lineString.getCoordinates()) {
            GeometryEncoderHelper.encodePosition(bsonWriter, position);
        }
        bsonWriter.writeEndArray();
    }

    private static void encodeMultiLineString(BsonWriter bsonWriter, MultiLineString multiLineString) {
        bsonWriter.writeStartArray();
        for (List<Position> list : multiLineString.getCoordinates()) {
            bsonWriter.writeStartArray();
            for (Position position : list) {
                GeometryEncoderHelper.encodePosition(bsonWriter, position);
            }
            bsonWriter.writeEndArray();
        }
        bsonWriter.writeEndArray();
    }

    private static void encodeGeometryCollection(BsonWriter bsonWriter, GeometryCollection geometryCollection, EncoderContext encoderContext, CodecRegistry codecRegistry) {
        bsonWriter.writeStartArray();
        for (Geometry geometry : geometryCollection.getGeometries()) {
            GeometryEncoderHelper.encodeGeometry(bsonWriter, geometry, encoderContext, codecRegistry);
        }
        bsonWriter.writeEndArray();
    }

    static void encodeCoordinateReferenceSystem(BsonWriter bsonWriter, Geometry geometry, EncoderContext encoderContext, CodecRegistry codecRegistry) {
        CoordinateReferenceSystem coordinateReferenceSystem = geometry.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != null) {
            bsonWriter.writeName("crs");
            Codec<?> codec = codecRegistry.get(coordinateReferenceSystem.getClass());
            encoderContext.encodeWithChildContext(codec, bsonWriter, coordinateReferenceSystem);
        }
    }

    static void encodePolygonCoordinates(BsonWriter bsonWriter, PolygonCoordinates polygonCoordinates) {
        bsonWriter.writeStartArray();
        GeometryEncoderHelper.encodeLinearRing(polygonCoordinates.getExterior(), bsonWriter);
        for (List<Position> list : polygonCoordinates.getHoles()) {
            GeometryEncoderHelper.encodeLinearRing(list, bsonWriter);
        }
        bsonWriter.writeEndArray();
    }

    private static void encodeLinearRing(List<Position> list, BsonWriter bsonWriter) {
        bsonWriter.writeStartArray();
        for (Position position : list) {
            GeometryEncoderHelper.encodePosition(bsonWriter, position);
        }
        bsonWriter.writeEndArray();
    }

    static void encodePosition(BsonWriter bsonWriter, Position position) {
        bsonWriter.writeStartArray();
        for (double d : position.getValues()) {
            bsonWriter.writeDouble(d);
        }
        bsonWriter.writeEndArray();
    }

    private GeometryEncoderHelper() {
    }
}

