/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.mql;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.mql.BranchesIntermediary;
import com.mongodb.client.model.mql.MqlArray;
import com.mongodb.client.model.mql.MqlBoolean;
import com.mongodb.client.model.mql.MqlDate;
import com.mongodb.client.model.mql.MqlDocument;
import com.mongodb.client.model.mql.MqlExpression;
import com.mongodb.client.model.mql.MqlInteger;
import com.mongodb.client.model.mql.MqlMap;
import com.mongodb.client.model.mql.MqlNumber;
import com.mongodb.client.model.mql.MqlString;
import com.mongodb.client.model.mql.MqlValue;
import com.mongodb.client.model.mql.SwitchCase;
import java.util.ArrayList;
import java.util.function.Function;

@Beta(value={Reason.CLIENT})
public final class Branches<T extends MqlValue> {
    Branches() {
    }

    private static <T extends MqlValue, R extends MqlValue> BranchesIntermediary<T, R> with(Function<T, SwitchCase<R>> function) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(function);
        return new BranchesIntermediary(arrayList);
    }

    private static <T extends MqlValue> MqlExpression<?> mqlEx(T t) {
        return (MqlExpression)t;
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> is(Function<? super T, MqlBoolean> function, Function<? super T, ? extends R> function2) {
        Assertions.notNull("predicate", function);
        Assertions.notNull("mapping", function2);
        return Branches.with(mqlValue -> new SwitchCase<MqlValue>((MqlBoolean)function.apply(mqlValue), (MqlValue)function2.apply(mqlValue)));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> eq(T t, Function<? super T, ? extends R> function) {
        Assertions.notNull("v", t);
        Assertions.notNull("mapping", function);
        return this.is(mqlValue2 -> mqlValue2.eq((MqlValue)t), function);
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> lt(T t, Function<? super T, ? extends R> function) {
        Assertions.notNull("v", t);
        Assertions.notNull("mapping", function);
        return this.is(mqlValue2 -> mqlValue2.lt((MqlValue)t), function);
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> lte(T t, Function<? super T, ? extends R> function) {
        Assertions.notNull("v", t);
        Assertions.notNull("mapping", function);
        return this.is(mqlValue2 -> mqlValue2.lte((MqlValue)t), function);
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isBoolean(Function<? super MqlBoolean, ? extends R> function) {
        Assertions.notNull("mapping", function);
        return this.is(mqlValue -> Branches.mqlEx(mqlValue).isBoolean(), mqlValue -> (MqlValue)function.apply((MqlBoolean)mqlValue));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isNumber(Function<? super MqlNumber, ? extends R> function) {
        Assertions.notNull("mapping", function);
        return this.is(mqlValue -> Branches.mqlEx(mqlValue).isNumber(), mqlValue -> (MqlValue)function.apply((MqlNumber)mqlValue));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isInteger(Function<? super MqlInteger, ? extends R> function) {
        Assertions.notNull("mapping", function);
        return this.is(mqlValue -> Branches.mqlEx(mqlValue).isInteger(), mqlValue -> (MqlValue)function.apply((MqlInteger)mqlValue));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isString(Function<? super MqlString, ? extends R> function) {
        Assertions.notNull("mapping", function);
        return this.is(mqlValue -> Branches.mqlEx(mqlValue).isString(), mqlValue -> (MqlValue)function.apply((MqlString)mqlValue));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isDate(Function<? super MqlDate, ? extends R> function) {
        Assertions.notNull("mapping", function);
        return this.is(mqlValue -> Branches.mqlEx(mqlValue).isDate(), mqlValue -> (MqlValue)function.apply((MqlDate)mqlValue));
    }

    public <R extends MqlValue, Q extends MqlValue> BranchesIntermediary<T, R> isArray(Function<? super MqlArray<Q>, ? extends R> function) {
        Assertions.notNull("mapping", function);
        return this.is(mqlValue -> Branches.mqlEx(mqlValue).isArray(), mqlValue -> (MqlValue)function.apply((MqlArray)mqlValue));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isDocument(Function<? super MqlDocument, ? extends R> function) {
        Assertions.notNull("mapping", function);
        return this.is(mqlValue -> Branches.mqlEx(mqlValue).isDocumentOrMap(), mqlValue -> (MqlValue)function.apply((MqlDocument)mqlValue));
    }

    public <R extends MqlValue, Q extends MqlValue> BranchesIntermediary<T, R> isMap(Function<? super MqlMap<Q>, ? extends R> function) {
        Assertions.notNull("mapping", function);
        return this.is(mqlValue -> Branches.mqlEx(mqlValue).isDocumentOrMap(), mqlValue -> (MqlValue)function.apply((MqlMap)mqlValue));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isNull(Function<? super MqlValue, ? extends R> function) {
        Assertions.notNull("mapping", function);
        return this.is(mqlValue -> Branches.mqlEx(mqlValue).isNull(), mqlValue -> (MqlValue)function.apply((MqlValue)mqlValue));
    }
}

