/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.mql;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.client.model.mql.Branches;
import com.mongodb.client.model.mql.BranchesTerminal;
import com.mongodb.client.model.mql.MqlBoolean;
import com.mongodb.client.model.mql.MqlEntry;
import com.mongodb.client.model.mql.MqlInteger;
import com.mongodb.client.model.mql.MqlMap;
import com.mongodb.client.model.mql.MqlNumber;
import com.mongodb.client.model.mql.MqlString;
import com.mongodb.client.model.mql.MqlValue;
import com.mongodb.client.model.mql.MqlValues;
import java.util.function.Function;

@Sealed
@Beta(value={Reason.CLIENT})
public interface MqlArray<T extends MqlValue>
extends MqlValue {
    public MqlArray<T> filter(Function<? super T, ? extends MqlBoolean> var1);

    public <R extends MqlValue> MqlArray<R> map(Function<? super T, ? extends R> var1);

    public MqlInteger size();

    public MqlBoolean any(Function<? super T, MqlBoolean> var1);

    public MqlBoolean all(Function<? super T, MqlBoolean> var1);

    public MqlNumber sum(Function<? super T, ? extends MqlNumber> var1);

    public MqlNumber multiply(Function<? super T, ? extends MqlNumber> var1);

    public T max(T var1);

    public T min(T var1);

    public MqlArray<T> maxN(MqlInteger var1);

    public MqlArray<T> minN(MqlInteger var1);

    public MqlString joinStrings(Function<? super T, MqlString> var1);

    public <R extends MqlValue> MqlArray<R> concatArrays(Function<? super T, ? extends MqlArray<? extends R>> var1);

    public <R extends MqlValue> MqlArray<R> unionArrays(Function<? super T, ? extends MqlArray<? extends R>> var1);

    public <R extends MqlValue> MqlMap<R> asMap(Function<? super T, ? extends MqlEntry<? extends R>> var1);

    public T elementAt(MqlInteger var1);

    default public T elementAt(int n) {
        return this.elementAt(MqlValues.of(n));
    }

    public T first();

    public T last();

    public MqlBoolean contains(T var1);

    public MqlArray<T> concat(MqlArray<? extends T> var1);

    public MqlArray<T> slice(MqlInteger var1, MqlInteger var2);

    default public MqlArray<T> slice(int n, int n2) {
        return this.slice(MqlValues.of(n), MqlValues.of(n2));
    }

    public MqlArray<T> union(MqlArray<? extends T> var1);

    public MqlArray<T> distinct();

    public <R extends MqlValue> R passArrayTo(Function<? super MqlArray<T>, ? extends R> var1);

    public <R extends MqlValue> R switchArrayOn(Function<Branches<MqlArray<T>>, ? extends BranchesTerminal<MqlArray<T>, ? extends R>> var1);
}

