/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.mql;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.mql.Branches;
import com.mongodb.client.model.mql.BranchesTerminal;
import com.mongodb.client.model.mql.MqlArray;
import com.mongodb.client.model.mql.MqlBoolean;
import com.mongodb.client.model.mql.MqlDate;
import com.mongodb.client.model.mql.MqlInteger;
import com.mongodb.client.model.mql.MqlMap;
import com.mongodb.client.model.mql.MqlNumber;
import com.mongodb.client.model.mql.MqlString;
import com.mongodb.client.model.mql.MqlValue;
import com.mongodb.client.model.mql.MqlValues;
import java.time.Instant;
import java.util.function.Function;
import org.bson.conversions.Bson;

@Sealed
@Beta(value={Reason.CLIENT})
public interface MqlDocument
extends MqlValue {
    public MqlBoolean hasField(String var1);

    public MqlDocument setField(String var1, MqlValue var2);

    public MqlDocument unsetField(String var1);

    public MqlValue getField(String var1);

    public MqlBoolean getBoolean(String var1);

    public MqlBoolean getBoolean(String var1, MqlBoolean var2);

    default public MqlBoolean getBoolean(String string, boolean bl) {
        Assertions.notNull("fieldName", string);
        return this.getBoolean(string, MqlValues.of(bl));
    }

    public MqlNumber getNumber(String var1);

    public MqlNumber getNumber(String var1, MqlNumber var2);

    default public MqlNumber getNumber(String string, Number number) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("other", number);
        return this.getNumber(string, MqlValues.numberToMqlNumber(number));
    }

    public MqlInteger getInteger(String var1);

    public MqlInteger getInteger(String var1, MqlInteger var2);

    default public MqlInteger getInteger(String string, int n) {
        Assertions.notNull("fieldName", string);
        return this.getInteger(string, MqlValues.of(n));
    }

    default public MqlInteger getInteger(String string, long l) {
        Assertions.notNull("fieldName", string);
        return this.getInteger(string, MqlValues.of(l));
    }

    public MqlString getString(String var1);

    public MqlString getString(String var1, MqlString var2);

    default public MqlString getString(String string, String string2) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("other", string2);
        return this.getString(string, MqlValues.of(string2));
    }

    public MqlDate getDate(String var1);

    public MqlDate getDate(String var1, MqlDate var2);

    default public MqlDate getDate(String string, Instant instant) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("other", instant);
        return this.getDate(string, MqlValues.of(instant));
    }

    public MqlDocument getDocument(String var1);

    public MqlDocument getDocument(String var1, MqlDocument var2);

    default public MqlDocument getDocument(String string, Bson bson) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("other", bson);
        return this.getDocument(string, MqlValues.of(bson));
    }

    public <T extends MqlValue> MqlMap<T> getMap(String var1);

    public <T extends MqlValue> MqlMap<T> getMap(String var1, MqlMap<? extends T> var2);

    default public <T extends MqlValue> MqlMap<T> getMap(String string, Bson bson) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("other", bson);
        return this.getMap(string, MqlValues.ofMap(bson));
    }

    public <T extends MqlValue> MqlArray<T> getArray(String var1);

    public <T extends MqlValue> MqlArray<T> getArray(String var1, MqlArray<? extends T> var2);

    public MqlDocument merge(MqlDocument var1);

    public <T extends MqlValue> MqlMap<T> asMap();

    public <R extends MqlValue> R passDocumentTo(Function<? super MqlDocument, ? extends R> var1);

    public <R extends MqlValue> R switchDocumentOn(Function<Branches<MqlDocument>, ? extends BranchesTerminal<MqlDocument, ? extends R>> var1);
}

