/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.mql;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.mql.Branches;
import com.mongodb.client.model.mql.BranchesTerminal;
import com.mongodb.client.model.mql.MqlArray;
import com.mongodb.client.model.mql.MqlBoolean;
import com.mongodb.client.model.mql.MqlDate;
import com.mongodb.client.model.mql.MqlDocument;
import com.mongodb.client.model.mql.MqlEntry;
import com.mongodb.client.model.mql.MqlInteger;
import com.mongodb.client.model.mql.MqlMap;
import com.mongodb.client.model.mql.MqlNumber;
import com.mongodb.client.model.mql.MqlString;
import com.mongodb.client.model.mql.MqlValue;
import com.mongodb.client.model.mql.MqlValues;
import com.mongodb.client.model.mql.SwitchCase;
import java.util.Collections;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;

final class MqlExpression<T extends MqlValue>
implements MqlValue,
MqlBoolean,
MqlInteger,
MqlNumber,
MqlString,
MqlDate,
MqlDocument,
MqlArray<T>,
MqlMap<T>,
MqlEntry<T> {
    private final Function<CodecRegistry, AstPlaceholder> fn;

    MqlExpression(Function<CodecRegistry, AstPlaceholder> function) {
        this.fn = function;
    }

    BsonValue toBsonValue(CodecRegistry codecRegistry) {
        return this.fn.apply(codecRegistry).bsonValue;
    }

    private AstPlaceholder astDoc(String string, BsonDocument bsonDocument) {
        return new AstPlaceholder(new BsonDocument(string, bsonDocument));
    }

    @Override
    public MqlString getKey() {
        return new MqlExpression<T>(this.getFieldInternal("k"));
    }

    @Override
    public T getValue() {
        return (T)MqlExpression.newMqlExpression(this.getFieldInternal("v"));
    }

    @Override
    public MqlEntry<T> setValue(T t) {
        Assertions.notNull("value", t);
        return this.setFieldInternal("v", (MqlValue)t);
    }

    @Override
    public MqlEntry<T> setKey(MqlString mqlString) {
        Assertions.notNull("key", mqlString);
        return this.setFieldInternal("k", mqlString);
    }

    private Function<CodecRegistry, AstPlaceholder> ast(String string) {
        return codecRegistry -> new AstPlaceholder(new BsonDocument(string, this.toBsonValue((CodecRegistry)codecRegistry)));
    }

    private Function<CodecRegistry, AstPlaceholder> astWrapped(String string) {
        return codecRegistry -> new AstPlaceholder(new BsonDocument(string, new BsonArray(Collections.singletonList(this.toBsonValue((CodecRegistry)codecRegistry)))));
    }

    private Function<CodecRegistry, AstPlaceholder> ast(String string, MqlValue mqlValue) {
        return codecRegistry -> {
            BsonArray bsonArray = new BsonArray();
            bsonArray.add(this.toBsonValue((CodecRegistry)codecRegistry));
            bsonArray.add(MqlExpression.toBsonValue(codecRegistry, mqlValue));
            return new AstPlaceholder(new BsonDocument(string, bsonArray));
        };
    }

    private Function<CodecRegistry, AstPlaceholder> ast(String string, MqlValue mqlValue, MqlValue mqlValue2) {
        return codecRegistry -> {
            BsonArray bsonArray = new BsonArray();
            bsonArray.add(this.toBsonValue((CodecRegistry)codecRegistry));
            bsonArray.add(MqlExpression.toBsonValue(codecRegistry, mqlValue));
            bsonArray.add(MqlExpression.toBsonValue(codecRegistry, mqlValue2));
            return new AstPlaceholder(new BsonDocument(string, bsonArray));
        };
    }

    static BsonValue toBsonValue(CodecRegistry codecRegistry, MqlValue mqlValue) {
        return ((MqlExpression)mqlValue).toBsonValue(codecRegistry);
    }

    <R extends MqlValue> R assertImplementsAllExpressions() {
        return (R)this;
    }

    private static <R extends MqlValue> R newMqlExpression(Function<CodecRegistry, AstPlaceholder> function) {
        return new MqlExpression(function).assertImplementsAllExpressions();
    }

    private <R extends MqlValue> R variable(String string) {
        return MqlExpression.newMqlExpression(codecRegistry -> new AstPlaceholder(new BsonString(string)));
    }

    @Override
    public MqlBoolean not() {
        return new MqlExpression<T>(this.ast("$not"));
    }

    @Override
    public MqlBoolean or(MqlBoolean mqlBoolean) {
        Assertions.notNull("other", mqlBoolean);
        return new MqlExpression<T>(this.ast("$or", mqlBoolean));
    }

    @Override
    public MqlBoolean and(MqlBoolean mqlBoolean) {
        Assertions.notNull("other", mqlBoolean);
        return new MqlExpression<T>(this.ast("$and", mqlBoolean));
    }

    public <R extends MqlValue> R cond(R r, R r2) {
        Assertions.notNull("ifTrue", r);
        Assertions.notNull("ifFalse", r2);
        return MqlExpression.newMqlExpression(this.ast("$cond", r, r2));
    }

    private Function<CodecRegistry, AstPlaceholder> getFieldInternal(String string) {
        return codecRegistry -> {
            BsonValue bsonValue = string.startsWith("$") ? new BsonDocument("$literal", new BsonString(string)) : new BsonString(string);
            return this.astDoc("$getField", new BsonDocument().append("input", this.fn.apply((CodecRegistry)codecRegistry).bsonValue).append("field", bsonValue));
        };
    }

    @Override
    public MqlValue getField(String string) {
        Assertions.notNull("fieldName", string);
        return new MqlExpression<T>(this.getFieldInternal(string));
    }

    @Override
    public MqlBoolean getBoolean(String string) {
        Assertions.notNull("fieldName", string);
        return new MqlExpression<T>(this.getFieldInternal(string));
    }

    @Override
    public MqlBoolean getBoolean(String string, MqlBoolean mqlBoolean) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("other", mqlBoolean);
        return this.getBoolean(string).isBooleanOr(mqlBoolean);
    }

    @Override
    public MqlNumber getNumber(String string) {
        Assertions.notNull("fieldName", string);
        return new MqlExpression<T>(this.getFieldInternal(string));
    }

    @Override
    public MqlNumber getNumber(String string, MqlNumber mqlNumber) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("other", mqlNumber);
        return this.getNumber(string).isNumberOr(mqlNumber);
    }

    @Override
    public MqlInteger getInteger(String string) {
        Assertions.notNull("fieldName", string);
        return new MqlExpression<T>(this.getFieldInternal(string));
    }

    @Override
    public MqlInteger getInteger(String string, MqlInteger mqlInteger) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("other", mqlInteger);
        return this.getInteger(string).isIntegerOr(mqlInteger);
    }

    @Override
    public MqlString getString(String string) {
        Assertions.notNull("fieldName", string);
        return new MqlExpression<T>(this.getFieldInternal(string));
    }

    @Override
    public MqlString getString(String string, MqlString mqlString) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("other", mqlString);
        return this.getString(string).isStringOr(mqlString);
    }

    @Override
    public MqlDate getDate(String string) {
        Assertions.notNull("fieldName", string);
        return new MqlExpression<T>(this.getFieldInternal(string));
    }

    @Override
    public MqlDate getDate(String string, MqlDate mqlDate) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("other", mqlDate);
        return this.getDate(string).isDateOr(mqlDate);
    }

    @Override
    public MqlDocument getDocument(String string) {
        Assertions.notNull("fieldName", string);
        return new MqlExpression<T>(this.getFieldInternal(string));
    }

    public <R extends MqlValue> MqlMap<R> getMap(String string) {
        Assertions.notNull("fieldName", string);
        return new MqlExpression<T>(this.getFieldInternal(string));
    }

    public <R extends MqlValue> MqlMap<R> getMap(String string, MqlMap<? extends R> mqlMap) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("other", mqlMap);
        return this.getMap(string).isMapOr(mqlMap);
    }

    @Override
    public MqlDocument getDocument(String string, MqlDocument mqlDocument) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("other", mqlDocument);
        return this.getDocument(string).isDocumentOr(mqlDocument);
    }

    public <R extends MqlValue> MqlArray<R> getArray(String string) {
        Assertions.notNull("fieldName", string);
        return new MqlExpression<T>(this.getFieldInternal(string));
    }

    public <R extends MqlValue> MqlArray<R> getArray(String string, MqlArray<? extends R> mqlArray) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("other", mqlArray);
        return this.getArray(string).isArrayOr(mqlArray);
    }

    @Override
    public MqlDocument merge(MqlDocument mqlDocument) {
        Assertions.notNull("other", mqlDocument);
        return new MqlExpression<T>(this.ast("$mergeObjects", mqlDocument));
    }

    @Override
    public MqlDocument setField(String string, MqlValue mqlValue) {
        Assertions.notNull("fieldName", string);
        Assertions.notNull("value", mqlValue);
        return this.setFieldInternal(string, mqlValue);
    }

    private MqlExpression<T> setFieldInternal(String string, MqlValue mqlValue) {
        Assertions.notNull("fieldName", string);
        return (MqlExpression)MqlExpression.newMqlExpression(codecRegistry -> this.astDoc("$setField", new BsonDocument().append("field", new BsonString(string)).append("input", this.toBsonValue((CodecRegistry)codecRegistry)).append("value", MqlExpression.toBsonValue(codecRegistry, mqlValue))));
    }

    @Override
    public MqlDocument unsetField(String string) {
        Assertions.notNull("fieldName", string);
        return (MqlDocument)MqlExpression.newMqlExpression(codecRegistry -> this.astDoc("$unsetField", new BsonDocument().append("field", new BsonString(string)).append("input", this.toBsonValue((CodecRegistry)codecRegistry))));
    }

    @Override
    public <R extends MqlValue> R passTo(Function<? super MqlValue, ? extends R> function) {
        Assertions.notNull("f", function);
        return (R)((MqlValue)function.apply((MqlValue)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchOn(Function<Branches<MqlValue>, ? extends BranchesTerminal<MqlValue, ? extends R>> function) {
        Assertions.notNull("mapping", function);
        return this.switchMapInternal((MqlValue)this.assertImplementsAllExpressions(), (BranchesTerminal)function.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passBooleanTo(Function<? super MqlBoolean, ? extends R> function) {
        Assertions.notNull("f", function);
        return (R)((MqlValue)function.apply((MqlBoolean)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchBooleanOn(Function<Branches<MqlBoolean>, ? extends BranchesTerminal<MqlBoolean, ? extends R>> function) {
        Assertions.notNull("mapping", function);
        return this.switchMapInternal((MqlBoolean)this.assertImplementsAllExpressions(), function.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passIntegerTo(Function<? super MqlInteger, ? extends R> function) {
        Assertions.notNull("f", function);
        return (R)((MqlValue)function.apply((MqlInteger)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchIntegerOn(Function<Branches<MqlInteger>, ? extends BranchesTerminal<MqlInteger, ? extends R>> function) {
        Assertions.notNull("mapping", function);
        return this.switchMapInternal((MqlInteger)this.assertImplementsAllExpressions(), function.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passNumberTo(Function<? super MqlNumber, ? extends R> function) {
        Assertions.notNull("f", function);
        return (R)((MqlValue)function.apply((MqlNumber)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchNumberOn(Function<Branches<MqlNumber>, ? extends BranchesTerminal<MqlNumber, ? extends R>> function) {
        Assertions.notNull("mapping", function);
        return this.switchMapInternal((MqlNumber)this.assertImplementsAllExpressions(), function.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passStringTo(Function<? super MqlString, ? extends R> function) {
        Assertions.notNull("f", function);
        return (R)((MqlValue)function.apply((MqlString)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchStringOn(Function<Branches<MqlString>, ? extends BranchesTerminal<MqlString, ? extends R>> function) {
        Assertions.notNull("mapping", function);
        return this.switchMapInternal((MqlString)this.assertImplementsAllExpressions(), function.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passDateTo(Function<? super MqlDate, ? extends R> function) {
        Assertions.notNull("f", function);
        return (R)((MqlValue)function.apply((MqlDate)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchDateOn(Function<Branches<MqlDate>, ? extends BranchesTerminal<MqlDate, ? extends R>> function) {
        Assertions.notNull("mapping", function);
        return this.switchMapInternal((MqlDate)this.assertImplementsAllExpressions(), function.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passArrayTo(Function<? super MqlArray<T>, ? extends R> function) {
        Assertions.notNull("f", function);
        return (R)((MqlValue)function.apply((MqlArray<R>)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchArrayOn(Function<Branches<MqlArray<T>>, ? extends BranchesTerminal<MqlArray<T>, ? extends R>> function) {
        Assertions.notNull("mapping", function);
        return this.switchMapInternal((MqlArray)this.assertImplementsAllExpressions(), function.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passMapTo(Function<? super MqlMap<T>, ? extends R> function) {
        Assertions.notNull("f", function);
        return (R)((MqlValue)function.apply((MqlMap<R>)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchMapOn(Function<Branches<MqlMap<T>>, ? extends BranchesTerminal<MqlMap<T>, ? extends R>> function) {
        Assertions.notNull("mapping", function);
        return this.switchMapInternal((MqlMap)this.assertImplementsAllExpressions(), function.apply(new Branches()));
    }

    @Override
    public <R extends MqlValue> R passDocumentTo(Function<? super MqlDocument, ? extends R> function) {
        Assertions.notNull("f", function);
        return (R)((MqlValue)function.apply((MqlDocument)this.assertImplementsAllExpressions()));
    }

    @Override
    public <R extends MqlValue> R switchDocumentOn(Function<Branches<MqlDocument>, ? extends BranchesTerminal<MqlDocument, ? extends R>> function) {
        Assertions.notNull("mapping", function);
        return this.switchMapInternal((MqlDocument)this.assertImplementsAllExpressions(), function.apply(new Branches()));
    }

    private <T0 extends MqlValue, R0 extends MqlValue> R0 switchMapInternal(T0 T0, BranchesTerminal<T0, R0> branchesTerminal) {
        return (R0)MqlExpression.newMqlExpression(codecRegistry -> {
            BsonArray bsonArray = new BsonArray();
            for (Function function : branchesTerminal.getBranches()) {
                SwitchCase switchCase = function.apply(T0);
                bsonArray.add(new BsonDocument().append("case", MqlExpression.toBsonValue(codecRegistry, switchCase.getCaseValue())).append("then", MqlExpression.toBsonValue(codecRegistry, switchCase.getThenValue())));
            }
            Object object = new BsonDocument().append("branches", bsonArray);
            if (branchesTerminal.getDefaults() != null) {
                object = ((BsonDocument)object).append("default", MqlExpression.toBsonValue(codecRegistry, (MqlValue)branchesTerminal.getDefaults().apply(T0)));
            }
            return this.astDoc("$switch", (BsonDocument)object);
        });
    }

    @Override
    public MqlBoolean eq(MqlValue mqlValue) {
        Assertions.notNull("other", mqlValue);
        return new MqlExpression<T>(this.ast("$eq", mqlValue));
    }

    @Override
    public MqlBoolean ne(MqlValue mqlValue) {
        Assertions.notNull("other", mqlValue);
        return new MqlExpression<T>(this.ast("$ne", mqlValue));
    }

    @Override
    public MqlBoolean gt(MqlValue mqlValue) {
        Assertions.notNull("other", mqlValue);
        return new MqlExpression<T>(this.ast("$gt", mqlValue));
    }

    @Override
    public MqlBoolean gte(MqlValue mqlValue) {
        Assertions.notNull("other", mqlValue);
        return new MqlExpression<T>(this.ast("$gte", mqlValue));
    }

    @Override
    public MqlBoolean lt(MqlValue mqlValue) {
        Assertions.notNull("other", mqlValue);
        return new MqlExpression<T>(this.ast("$lt", mqlValue));
    }

    @Override
    public MqlBoolean lte(MqlValue mqlValue) {
        Assertions.notNull("other", mqlValue);
        return new MqlExpression<T>(this.ast("$lte", mqlValue));
    }

    MqlBoolean isBoolean() {
        return new MqlExpression<T>(this.astWrapped("$type")).eq(MqlValues.of("bool"));
    }

    @Override
    public MqlBoolean isBooleanOr(MqlBoolean mqlBoolean) {
        Assertions.notNull("other", mqlBoolean);
        return this.isBoolean().cond(this, mqlBoolean);
    }

    MqlBoolean isNumber() {
        return new MqlExpression<T>(this.astWrapped("$isNumber"));
    }

    @Override
    public MqlNumber isNumberOr(MqlNumber mqlNumber) {
        Assertions.notNull("other", mqlNumber);
        return this.isNumber().cond(this, mqlNumber);
    }

    MqlBoolean isInteger() {
        return (MqlBoolean)this.switchOn(branches -> branches.isNumber(mqlNumber -> mqlNumber.round().eq((MqlValue)mqlNumber)).defaults(mqlValue -> MqlValues.of(false)));
    }

    @Override
    public MqlInteger isIntegerOr(MqlInteger mqlInteger) {
        Assertions.notNull("other", mqlInteger);
        return (MqlInteger)this.switchOn(branches -> branches.isNumber(mqlNumber -> mqlNumber.round().eq((MqlValue)mqlNumber).cond(mqlNumber, mqlInteger)).defaults(mqlValue -> mqlInteger));
    }

    MqlBoolean isString() {
        return new MqlExpression<T>(this.astWrapped("$type")).eq(MqlValues.of("string"));
    }

    @Override
    public MqlString isStringOr(MqlString mqlString) {
        Assertions.notNull("other", mqlString);
        return this.isString().cond(this, mqlString);
    }

    MqlBoolean isDate() {
        return MqlValues.ofStringArray("date").contains(new MqlExpression<T>(this.astWrapped("$type")));
    }

    @Override
    public MqlDate isDateOr(MqlDate mqlDate) {
        Assertions.notNull("other", mqlDate);
        return this.isDate().cond(this, mqlDate);
    }

    MqlBoolean isArray() {
        return new MqlExpression<T>(this.astWrapped("$isArray"));
    }

    public <R extends MqlValue> MqlArray<R> isArrayOr(MqlArray<? extends R> mqlArray) {
        Assertions.notNull("other", mqlArray);
        return this.isArray().cond((MqlArray)this.assertImplementsAllExpressions(), mqlArray);
    }

    MqlBoolean isDocumentOrMap() {
        return new MqlExpression<T>(this.astWrapped("$type")).eq(MqlValues.of("object"));
    }

    public <R extends MqlDocument> R isDocumentOr(R r) {
        Assertions.notNull("other", r);
        return (R)this.isDocumentOrMap().cond((MqlDocument)this.assertImplementsAllExpressions(), r);
    }

    public <R extends MqlValue> MqlMap<R> isMapOr(MqlMap<? extends R> mqlMap) {
        Assertions.notNull("other", mqlMap);
        MqlExpression mqlExpression = (MqlExpression)this.isDocumentOrMap();
        return (MqlMap)MqlExpression.newMqlExpression(mqlExpression.ast("$cond", (MqlValue)this.assertImplementsAllExpressions(), mqlMap));
    }

    MqlBoolean isNull() {
        return this.eq(MqlValues.ofNull());
    }

    @Override
    public MqlString asString() {
        return new MqlExpression<T>(this.astWrapped("$toString"));
    }

    private Function<CodecRegistry, AstPlaceholder> convertInternal(String string, MqlValue mqlValue) {
        return codecRegistry -> this.astDoc("$convert", new BsonDocument().append("input", this.fn.apply((CodecRegistry)codecRegistry).bsonValue).append("onError", MqlExpression.toBsonValue(codecRegistry, mqlValue)).append("to", new BsonString(string)));
    }

    @Override
    public MqlInteger parseInteger() {
        MqlExpression<T> mqlExpression = new MqlExpression<T>(this.ast("$toLong"));
        return new MqlExpression<T>(this.convertInternal("int", mqlExpression));
    }

    @Override
    public <R extends MqlValue> MqlArray<R> map(Function<? super T, ? extends R> function) {
        Assertions.notNull("in", function);
        Object r = this.variable("$$this");
        return new MqlExpression<T>(codecRegistry -> this.astDoc("$map", new BsonDocument().append("input", this.toBsonValue((CodecRegistry)codecRegistry)).append("in", MqlExpression.toBsonValue(codecRegistry, (MqlValue)function.apply((T)r)))));
    }

    @Override
    public MqlArray<T> filter(Function<? super T, ? extends MqlBoolean> function) {
        Assertions.notNull("predicate", function);
        Object r = this.variable("$$this");
        return new MqlExpression<T>(codecRegistry -> this.astDoc("$filter", new BsonDocument().append("input", this.toBsonValue((CodecRegistry)codecRegistry)).append("cond", MqlExpression.toBsonValue(codecRegistry, (MqlValue)function.apply((T)r)))));
    }

    MqlArray<T> sort() {
        return new MqlExpression<T>(codecRegistry -> this.astDoc("$sortArray", new BsonDocument().append("input", this.toBsonValue((CodecRegistry)codecRegistry)).append("sortBy", new BsonInt32(1))));
    }

    private T reduce(T t, BinaryOperator<T> binaryOperator) {
        Object r = this.variable("$$this");
        Object r2 = this.variable("$$value");
        return (T)MqlExpression.newMqlExpression(codecRegistry -> this.astDoc("$reduce", new BsonDocument().append("input", this.toBsonValue((CodecRegistry)codecRegistry)).append("initialValue", MqlExpression.toBsonValue(codecRegistry, t)).append("in", MqlExpression.toBsonValue(codecRegistry, (MqlValue)binaryOperator.apply(r2, r)))));
    }

    @Override
    public MqlBoolean any(Function<? super T, MqlBoolean> function) {
        Assertions.notNull("predicate", function);
        MqlExpression mqlExpression = (MqlExpression)this.map(function);
        return mqlExpression.reduce(MqlValues.of(false), (mqlBoolean, mqlBoolean2) -> mqlBoolean.or((MqlBoolean)mqlBoolean2));
    }

    @Override
    public MqlBoolean all(Function<? super T, MqlBoolean> function) {
        Assertions.notNull("predicate", function);
        MqlExpression mqlExpression = (MqlExpression)this.map(function);
        return mqlExpression.reduce(MqlValues.of(true), (mqlBoolean, mqlBoolean2) -> mqlBoolean.and((MqlBoolean)mqlBoolean2));
    }

    @Override
    public MqlNumber sum(Function<? super T, ? extends MqlNumber> function) {
        Assertions.notNull("mapper", function);
        MqlExpression mqlExpression = (MqlExpression)this.map(function);
        return mqlExpression.reduce(MqlValues.of(0), (mqlNumber, mqlNumber2) -> mqlNumber.add((MqlNumber)mqlNumber2));
    }

    @Override
    public MqlNumber multiply(Function<? super T, ? extends MqlNumber> function) {
        Assertions.notNull("mapper", function);
        MqlExpression mqlExpression = (MqlExpression)this.map(function);
        return mqlExpression.reduce(MqlValues.of(1), (mqlNumber, mqlNumber2) -> mqlNumber.multiply((MqlNumber)mqlNumber2));
    }

    @Override
    public T max(T t) {
        Assertions.notNull("other", t);
        return this.size().eq(MqlValues.of(0)).cond(t, this.maxN(MqlValues.of(1)).first());
    }

    @Override
    public T min(T t) {
        Assertions.notNull("other", t);
        return this.size().eq(MqlValues.of(0)).cond(t, this.minN(MqlValues.of(1)).first());
    }

    @Override
    public MqlArray<T> maxN(MqlInteger mqlInteger) {
        Assertions.notNull("n", mqlInteger);
        return (MqlArray)MqlExpression.newMqlExpression(codecRegistry -> this.astDoc("$maxN", new BsonDocument().append("input", MqlExpression.toBsonValue(codecRegistry, this)).append("n", MqlExpression.toBsonValue(codecRegistry, mqlInteger))));
    }

    @Override
    public MqlArray<T> minN(MqlInteger mqlInteger) {
        Assertions.notNull("n", mqlInteger);
        return (MqlArray)MqlExpression.newMqlExpression(codecRegistry -> this.astDoc("$minN", new BsonDocument().append("input", MqlExpression.toBsonValue(codecRegistry, this)).append("n", MqlExpression.toBsonValue(codecRegistry, mqlInteger))));
    }

    @Override
    public MqlString joinStrings(Function<? super T, MqlString> function) {
        Assertions.notNull("mapper", function);
        MqlExpression mqlExpression = (MqlExpression)this.map(function);
        return mqlExpression.reduce(MqlValues.of(""), (mqlString, mqlString2) -> mqlString.append((MqlString)mqlString2));
    }

    @Override
    public <R extends MqlValue> MqlArray<R> concatArrays(Function<? super T, ? extends MqlArray<? extends R>> function) {
        Assertions.notNull("mapper", function);
        MqlExpression mqlExpression = (MqlExpression)this.map(function);
        return mqlExpression.reduce(MqlValues.ofArray((MqlValue[])new MqlValue[0]), (mqlArray, mqlArray2) -> mqlArray.concat(mqlArray2));
    }

    @Override
    public <R extends MqlValue> MqlArray<R> unionArrays(Function<? super T, ? extends MqlArray<? extends R>> function) {
        Assertions.notNull("mapper", function);
        Assertions.notNull("mapper", function);
        MqlExpression mqlExpression = (MqlExpression)this.map(function);
        return mqlExpression.reduce(MqlValues.ofArray((MqlValue[])new MqlValue[0]), (mqlArray, mqlArray2) -> mqlArray.union(mqlArray2));
    }

    @Override
    public MqlInteger size() {
        return new MqlExpression<T>(this.astWrapped("$size"));
    }

    @Override
    public T elementAt(MqlInteger mqlInteger) {
        Assertions.notNull("i", mqlInteger);
        return (T)new MqlExpression<T>(this.ast("$arrayElemAt", mqlInteger)).assertImplementsAllExpressions();
    }

    @Override
    public T first() {
        return (T)new MqlExpression<T>(this.astWrapped("$first")).assertImplementsAllExpressions();
    }

    @Override
    public T last() {
        return (T)new MqlExpression<T>(this.astWrapped("$last")).assertImplementsAllExpressions();
    }

    @Override
    public MqlBoolean contains(T t) {
        Assertions.notNull("value", t);
        String string = "$in";
        return (MqlBoolean)new MqlExpression<T>(codecRegistry -> {
            BsonArray bsonArray = new BsonArray();
            bsonArray.add(MqlExpression.toBsonValue(codecRegistry, t));
            bsonArray.add(this.toBsonValue((CodecRegistry)codecRegistry));
            return new AstPlaceholder(new BsonDocument(string, bsonArray));
        }).assertImplementsAllExpressions();
    }

    @Override
    public MqlArray<T> concat(MqlArray<? extends T> mqlArray) {
        Assertions.notNull("other", mqlArray);
        return (MqlArray)new MqlExpression<T>(this.ast("$concatArrays", mqlArray)).assertImplementsAllExpressions();
    }

    @Override
    public MqlArray<T> slice(MqlInteger mqlInteger, MqlInteger mqlInteger2) {
        Assertions.notNull("start", mqlInteger);
        Assertions.notNull("length", mqlInteger2);
        return (MqlArray)new MqlExpression<T>(this.ast("$slice", mqlInteger, mqlInteger2)).assertImplementsAllExpressions();
    }

    @Override
    public MqlArray<T> union(MqlArray<? extends T> mqlArray) {
        Assertions.notNull("other", mqlArray);
        return (MqlArray)new MqlExpression<T>(this.ast("$setUnion", mqlArray)).assertImplementsAllExpressions();
    }

    @Override
    public MqlArray<T> distinct() {
        return new MqlExpression<T>(this.astWrapped("$setUnion"));
    }

    @Override
    public MqlInteger multiply(MqlNumber mqlNumber) {
        Assertions.notNull("other", mqlNumber);
        return (MqlInteger)MqlExpression.newMqlExpression(this.ast("$multiply", mqlNumber));
    }

    @Override
    public MqlNumber add(MqlNumber mqlNumber) {
        Assertions.notNull("other", mqlNumber);
        return new MqlExpression<T>(this.ast("$add", mqlNumber));
    }

    @Override
    public MqlNumber divide(MqlNumber mqlNumber) {
        Assertions.notNull("other", mqlNumber);
        return new MqlExpression<T>(this.ast("$divide", mqlNumber));
    }

    @Override
    public MqlNumber max(MqlNumber mqlNumber) {
        Assertions.notNull("other", mqlNumber);
        return new MqlExpression<T>(this.ast("$max", mqlNumber));
    }

    @Override
    public MqlNumber min(MqlNumber mqlNumber) {
        Assertions.notNull("other", mqlNumber);
        return new MqlExpression<T>(this.ast("$min", mqlNumber));
    }

    @Override
    public MqlInteger round() {
        return new MqlExpression<T>(this.ast("$round"));
    }

    @Override
    public MqlNumber round(MqlInteger mqlInteger) {
        Assertions.notNull("place", mqlInteger);
        return new MqlExpression<T>(this.ast("$round", mqlInteger));
    }

    @Override
    public MqlInteger multiply(MqlInteger mqlInteger) {
        Assertions.notNull("other", mqlInteger);
        return new MqlExpression<T>(this.ast("$multiply", mqlInteger));
    }

    @Override
    public MqlInteger abs() {
        return (MqlInteger)MqlExpression.newMqlExpression(this.ast("$abs"));
    }

    @Override
    public MqlDate millisecondsAsDate() {
        return (MqlDate)MqlExpression.newMqlExpression(this.ast("$toDate"));
    }

    @Override
    public MqlNumber subtract(MqlNumber mqlNumber) {
        Assertions.notNull("other", mqlNumber);
        return new MqlExpression<T>(this.ast("$subtract", mqlNumber));
    }

    @Override
    public MqlInteger add(MqlInteger mqlInteger) {
        Assertions.notNull("other", mqlInteger);
        return new MqlExpression<T>(this.ast("$add", mqlInteger));
    }

    @Override
    public MqlInteger subtract(MqlInteger mqlInteger) {
        Assertions.notNull("other", mqlInteger);
        return new MqlExpression<T>(this.ast("$subtract", mqlInteger));
    }

    @Override
    public MqlInteger max(MqlInteger mqlInteger) {
        Assertions.notNull("other", mqlInteger);
        return new MqlExpression<T>(this.ast("$max", mqlInteger));
    }

    @Override
    public MqlInteger min(MqlInteger mqlInteger) {
        Assertions.notNull("other", mqlInteger);
        return new MqlExpression<T>(this.ast("$min", mqlInteger));
    }

    private MqlExpression<MqlValue> usingTimezone(String string, MqlString mqlString) {
        return new MqlExpression<MqlValue>(codecRegistry -> this.astDoc(string, new BsonDocument().append("date", this.toBsonValue((CodecRegistry)codecRegistry)).append("timezone", MqlExpression.toBsonValue(codecRegistry, mqlString))));
    }

    @Override
    public MqlInteger year(MqlString mqlString) {
        Assertions.notNull("timezone", mqlString);
        return this.usingTimezone("$year", mqlString);
    }

    @Override
    public MqlInteger month(MqlString mqlString) {
        Assertions.notNull("timezone", mqlString);
        return this.usingTimezone("$month", mqlString);
    }

    @Override
    public MqlInteger dayOfMonth(MqlString mqlString) {
        Assertions.notNull("timezone", mqlString);
        return this.usingTimezone("$dayOfMonth", mqlString);
    }

    @Override
    public MqlInteger dayOfWeek(MqlString mqlString) {
        Assertions.notNull("timezone", mqlString);
        return this.usingTimezone("$dayOfWeek", mqlString);
    }

    @Override
    public MqlInteger dayOfYear(MqlString mqlString) {
        Assertions.notNull("timezone", mqlString);
        return this.usingTimezone("$dayOfYear", mqlString);
    }

    @Override
    public MqlInteger hour(MqlString mqlString) {
        Assertions.notNull("timezone", mqlString);
        return this.usingTimezone("$hour", mqlString);
    }

    @Override
    public MqlInteger minute(MqlString mqlString) {
        Assertions.notNull("timezone", mqlString);
        return this.usingTimezone("$minute", mqlString);
    }

    @Override
    public MqlInteger second(MqlString mqlString) {
        Assertions.notNull("timezone", mqlString);
        return this.usingTimezone("$second", mqlString);
    }

    @Override
    public MqlInteger week(MqlString mqlString) {
        Assertions.notNull("timezone", mqlString);
        return this.usingTimezone("$week", mqlString);
    }

    @Override
    public MqlInteger millisecond(MqlString mqlString) {
        Assertions.notNull("timezone", mqlString);
        return this.usingTimezone("$millisecond", mqlString);
    }

    @Override
    public MqlString asString(MqlString mqlString, MqlString mqlString2) {
        Assertions.notNull("timezone", mqlString);
        Assertions.notNull("format", mqlString2);
        return (MqlString)MqlExpression.newMqlExpression(codecRegistry -> this.astDoc("$dateToString", new BsonDocument().append("date", this.toBsonValue((CodecRegistry)codecRegistry)).append("format", MqlExpression.toBsonValue(codecRegistry, mqlString2)).append("timezone", MqlExpression.toBsonValue(codecRegistry, mqlString))));
    }

    @Override
    public MqlDate parseDate(MqlString mqlString, MqlString mqlString2) {
        Assertions.notNull("timezone", mqlString);
        Assertions.notNull("format", mqlString2);
        return (MqlDate)MqlExpression.newMqlExpression(codecRegistry -> this.astDoc("$dateFromString", new BsonDocument().append("dateString", this.toBsonValue((CodecRegistry)codecRegistry)).append("format", MqlExpression.toBsonValue(codecRegistry, mqlString2)).append("timezone", MqlExpression.toBsonValue(codecRegistry, mqlString))));
    }

    @Override
    public MqlDate parseDate(MqlString mqlString) {
        Assertions.notNull("format", mqlString);
        return (MqlDate)MqlExpression.newMqlExpression(codecRegistry -> this.astDoc("$dateFromString", new BsonDocument().append("dateString", this.toBsonValue((CodecRegistry)codecRegistry)).append("format", MqlExpression.toBsonValue(codecRegistry, mqlString))));
    }

    @Override
    public MqlDate parseDate() {
        return (MqlDate)MqlExpression.newMqlExpression(codecRegistry -> this.astDoc("$dateFromString", new BsonDocument().append("dateString", this.toBsonValue((CodecRegistry)codecRegistry))));
    }

    @Override
    public MqlString toLower() {
        return new MqlExpression<T>(this.ast("$toLower"));
    }

    @Override
    public MqlString toUpper() {
        return new MqlExpression<T>(this.ast("$toUpper"));
    }

    @Override
    public MqlString append(MqlString mqlString) {
        Assertions.notNull("other", mqlString);
        return new MqlExpression<T>(this.ast("$concat", mqlString));
    }

    @Override
    public MqlInteger length() {
        return new MqlExpression<T>(this.ast("$strLenCP"));
    }

    @Override
    public MqlInteger lengthBytes() {
        return new MqlExpression<T>(this.ast("$strLenBytes"));
    }

    @Override
    public MqlString substr(MqlInteger mqlInteger, MqlInteger mqlInteger2) {
        Assertions.notNull("start", mqlInteger);
        Assertions.notNull("length", mqlInteger2);
        return new MqlExpression<T>(this.ast("$substrCP", mqlInteger, mqlInteger2));
    }

    @Override
    public MqlString substrBytes(MqlInteger mqlInteger, MqlInteger mqlInteger2) {
        Assertions.notNull("start", mqlInteger);
        Assertions.notNull("length", mqlInteger2);
        return new MqlExpression<T>(this.ast("$substrBytes", mqlInteger, mqlInteger2));
    }

    @Override
    public MqlBoolean has(MqlString mqlString) {
        Assertions.notNull("key", mqlString);
        return this.get(mqlString).ne((MqlValue)MqlExpression.ofRem());
    }

    @Override
    public MqlBoolean hasField(String string) {
        Assertions.notNull("fieldName", string);
        return this.has(MqlValues.of(string));
    }

    static <R extends MqlValue> R ofRem() {
        return new MqlExpression(codecRegistry -> new AstPlaceholder(new BsonString("$$REMOVE"))).assertImplementsAllExpressions();
    }

    @Override
    public T get(MqlString mqlString) {
        Assertions.notNull("key", mqlString);
        return (T)MqlExpression.newMqlExpression(codecRegistry -> this.astDoc("$getField", new BsonDocument().append("input", this.fn.apply((CodecRegistry)codecRegistry).bsonValue).append("field", MqlExpression.toBsonValue(codecRegistry, mqlString))));
    }

    @Override
    public T get(MqlString mqlString, T t) {
        Assertions.notNull("key", mqlString);
        Assertions.notNull("other", t);
        MqlExpression mqlExpression = (MqlExpression)this.get(mqlString);
        return (T)mqlExpression.eq((MqlValue)MqlExpression.ofRem()).cond(t, mqlExpression);
    }

    @Override
    public MqlMap<T> set(MqlString mqlString, T t) {
        Assertions.notNull("key", mqlString);
        Assertions.notNull("value", t);
        return (MqlMap)MqlExpression.newMqlExpression(codecRegistry -> this.astDoc("$setField", new BsonDocument().append("field", MqlExpression.toBsonValue(codecRegistry, mqlString)).append("input", this.toBsonValue((CodecRegistry)codecRegistry)).append("value", MqlExpression.toBsonValue(codecRegistry, t))));
    }

    @Override
    public MqlMap<T> unset(MqlString mqlString) {
        Assertions.notNull("key", mqlString);
        return (MqlMap)MqlExpression.newMqlExpression(codecRegistry -> this.astDoc("$unsetField", new BsonDocument().append("field", MqlExpression.toBsonValue(codecRegistry, mqlString)).append("input", this.toBsonValue((CodecRegistry)codecRegistry))));
    }

    @Override
    public MqlMap<T> merge(MqlMap<? extends T> mqlMap) {
        Assertions.notNull("other", mqlMap);
        return new MqlExpression<T>(this.ast("$mergeObjects", mqlMap));
    }

    @Override
    public MqlArray<MqlEntry<T>> entries() {
        return (MqlArray)MqlExpression.newMqlExpression(this.ast("$objectToArray"));
    }

    @Override
    public <R extends MqlValue> MqlMap<R> asMap(Function<? super T, ? extends MqlEntry<? extends R>> function) {
        Assertions.notNull("mapper", function);
        MqlExpression mqlExpression = (MqlExpression)this.map(function);
        return (MqlMap)MqlExpression.newMqlExpression(mqlExpression.astWrapped("$arrayToObject"));
    }

    public <Q extends MqlValue> MqlMap<Q> asMap() {
        return this;
    }

    @Override
    public <R extends MqlDocument> R asDocument() {
        return (R)this;
    }

    static final class AstPlaceholder {
        private final BsonValue bsonValue;

        AstPlaceholder(BsonValue bsonValue) {
            this.bsonValue = bsonValue;
        }
    }
}

