/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.mql;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.mql.Branches;
import com.mongodb.client.model.mql.BranchesTerminal;
import com.mongodb.client.model.mql.MqlInteger;
import com.mongodb.client.model.mql.MqlValue;
import com.mongodb.client.model.mql.MqlValues;
import java.util.function.Function;

@Sealed
@Beta(value={Reason.CLIENT})
public interface MqlNumber
extends MqlValue {
    public MqlNumber multiply(MqlNumber var1);

    default public MqlNumber multiply(Number number) {
        Assertions.notNull("other", number);
        return this.multiply(MqlValues.numberToMqlNumber(number));
    }

    public MqlNumber divide(MqlNumber var1);

    default public MqlNumber divide(Number number) {
        Assertions.notNull("other", number);
        return this.divide(MqlValues.numberToMqlNumber(number));
    }

    public MqlNumber add(MqlNumber var1);

    default public MqlNumber add(Number number) {
        Assertions.notNull("other", number);
        return this.add(MqlValues.numberToMqlNumber(number));
    }

    public MqlNumber subtract(MqlNumber var1);

    default public MqlNumber subtract(Number number) {
        Assertions.notNull("other", number);
        return this.subtract(MqlValues.numberToMqlNumber(number));
    }

    public MqlNumber max(MqlNumber var1);

    public MqlNumber min(MqlNumber var1);

    public MqlInteger round();

    public MqlNumber round(MqlInteger var1);

    public MqlNumber abs();

    public <R extends MqlValue> R passNumberTo(Function<? super MqlNumber, ? extends R> var1);

    public <R extends MqlValue> R switchNumberOn(Function<Branches<MqlNumber>, ? extends BranchesTerminal<MqlNumber, ? extends R>> var1);
}

