/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.mql;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.client.model.mql.Branches;
import com.mongodb.client.model.mql.BranchesTerminal;
import com.mongodb.client.model.mql.MqlDate;
import com.mongodb.client.model.mql.MqlInteger;
import com.mongodb.client.model.mql.MqlValue;
import com.mongodb.client.model.mql.MqlValues;
import java.util.function.Function;

@Sealed
@Beta(value={Reason.CLIENT})
public interface MqlString
extends MqlValue {
    public MqlString toLower();

    public MqlString toUpper();

    public MqlString append(MqlString var1);

    public MqlInteger length();

    public MqlInteger lengthBytes();

    public MqlString substr(MqlInteger var1, MqlInteger var2);

    default public MqlString substr(int n, int n2) {
        return this.substr(MqlValues.of(n), MqlValues.of(n2));
    }

    public MqlString substrBytes(MqlInteger var1, MqlInteger var2);

    default public MqlString substrBytes(int n, int n2) {
        return this.substrBytes(MqlValues.of(n), MqlValues.of(n2));
    }

    public MqlInteger parseInteger();

    public MqlDate parseDate();

    public MqlDate parseDate(MqlString var1);

    public MqlDate parseDate(MqlString var1, MqlString var2);

    public <R extends MqlValue> R passStringTo(Function<? super MqlString, ? extends R> var1);

    public <R extends MqlValue> R switchStringOn(Function<Branches<MqlString>, ? extends BranchesTerminal<MqlString, ? extends R>> var1);
}

