/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.mql;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.mql.MqlArray;
import com.mongodb.client.model.mql.MqlBoolean;
import com.mongodb.client.model.mql.MqlDate;
import com.mongodb.client.model.mql.MqlDocument;
import com.mongodb.client.model.mql.MqlEntry;
import com.mongodb.client.model.mql.MqlExpression;
import com.mongodb.client.model.mql.MqlInteger;
import com.mongodb.client.model.mql.MqlMap;
import com.mongodb.client.model.mql.MqlNumber;
import com.mongodb.client.model.mql.MqlString;
import com.mongodb.client.model.mql.MqlValue;
import java.time.Instant;
import java.util.ArrayList;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.Decimal128;

@Beta(value={Reason.CLIENT})
public final class MqlValues {
    private MqlValues() {
    }

    public static MqlBoolean of(boolean bl) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonBoolean(bl)));
    }

    public static MqlArray<MqlBoolean> ofBooleanArray(boolean ... blArray) {
        Assertions.notNull("array", blArray);
        BsonArray bsonArray = new BsonArray();
        for (boolean bl : blArray) {
            bsonArray.add(new BsonBoolean(bl));
        }
        return new MqlExpression<MqlBoolean>(codecRegistry -> new MqlExpression.AstPlaceholder(bsonArray));
    }

    public static MqlInteger of(int n) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonInt32(n)));
    }

    public static MqlArray<MqlInteger> ofIntegerArray(int ... nArray) {
        Assertions.notNull("array", nArray);
        BsonArray bsonArray = new BsonArray();
        for (int n : nArray) {
            bsonArray.add(new BsonInt32(n));
        }
        return new MqlExpression<MqlInteger>(codecRegistry -> new MqlExpression.AstPlaceholder(bsonArray));
    }

    public static MqlInteger of(long l) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonInt64(l)));
    }

    public static MqlArray<MqlInteger> ofIntegerArray(long ... lArray) {
        Assertions.notNull("array", lArray);
        BsonArray bsonArray = new BsonArray();
        for (long l : lArray) {
            bsonArray.add(new BsonInt64(l));
        }
        return new MqlExpression<MqlInteger>(codecRegistry -> new MqlExpression.AstPlaceholder(bsonArray));
    }

    public static MqlNumber of(double d) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonDouble(d)));
    }

    public static MqlArray<MqlNumber> ofNumberArray(double ... dArray) {
        Assertions.notNull("array", dArray);
        BsonArray bsonArray = new BsonArray();
        for (double d : dArray) {
            bsonArray.add(new BsonDouble(d));
        }
        return new MqlExpression<MqlNumber>(codecRegistry -> new MqlExpression.AstPlaceholder(bsonArray));
    }

    public static MqlNumber of(Decimal128 decimal128) {
        Assertions.notNull("Decimal128", decimal128);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonDecimal128(decimal128)));
    }

    public static MqlArray<MqlNumber> ofNumberArray(Decimal128 ... decimal128Array) {
        Assertions.notNull("array", decimal128Array);
        ArrayList<BsonDecimal128> arrayList = new ArrayList<BsonDecimal128>();
        for (Decimal128 decimal128 : decimal128Array) {
            Assertions.notNull("elements of array", decimal128);
            arrayList.add(new BsonDecimal128(decimal128));
        }
        return new MqlExpression<MqlNumber>(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonArray(arrayList)));
    }

    public static MqlDate of(Instant instant) {
        Assertions.notNull("Instant", instant);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonDateTime(instant.toEpochMilli())));
    }

    public static MqlArray<MqlDate> ofDateArray(Instant ... instantArray) {
        Assertions.notNull("array", instantArray);
        ArrayList<BsonDateTime> arrayList = new ArrayList<BsonDateTime>();
        for (Instant instant : instantArray) {
            Assertions.notNull("elements of array", instant);
            arrayList.add(new BsonDateTime(instant.toEpochMilli()));
        }
        return new MqlExpression<MqlDate>(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonArray(arrayList)));
    }

    public static MqlString of(String string) {
        Assertions.notNull("String", string);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(MqlValues.wrapString(string)));
    }

    public static MqlArray<MqlString> ofStringArray(String ... stringArray) {
        Assertions.notNull("array", stringArray);
        ArrayList<BsonValue> arrayList = new ArrayList<BsonValue>();
        for (String string : stringArray) {
            Assertions.notNull("elements of array", string);
            arrayList.add(MqlValues.wrapString(string));
        }
        return new MqlExpression<MqlString>(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonArray(arrayList)));
    }

    private static BsonValue wrapString(String string) {
        BsonString bsonString = new BsonString(string);
        if (string.contains("$")) {
            return new BsonDocument("$literal", bsonString);
        }
        return bsonString;
    }

    public static MqlDocument current() {
        return (MqlDocument)new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonString("$$CURRENT"))).assertImplementsAllExpressions();
    }

    public static <R extends MqlValue> MqlMap<R> currentAsMap() {
        return (MqlMap)new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonString("$$CURRENT"))).assertImplementsAllExpressions();
    }

    @SafeVarargs
    public static <T extends MqlValue> MqlArray<T> ofArray(T ... TArray) {
        Assertions.notNull("array", TArray);
        return new MqlExpression(codecRegistry -> {
            BsonArray bsonArray = new BsonArray();
            for (MqlValue mqlValue : TArray) {
                Assertions.notNull("elements of array", mqlValue);
                bsonArray.add(((MqlExpression)mqlValue).toBsonValue((CodecRegistry)codecRegistry));
            }
            return new MqlExpression.AstPlaceholder(bsonArray);
        });
    }

    public static <T extends MqlValue> MqlEntry<T> ofEntry(MqlString mqlString, T t) {
        Assertions.notNull("k", mqlString);
        Assertions.notNull("v", t);
        return new MqlExpression(codecRegistry -> {
            BsonDocument bsonDocument = new BsonDocument();
            bsonDocument.put("k", MqlExpression.toBsonValue(codecRegistry, mqlString));
            bsonDocument.put("v", MqlExpression.toBsonValue(codecRegistry, t));
            return new MqlExpression.AstPlaceholder(bsonDocument);
        });
    }

    public static <T extends MqlValue> MqlMap<T> ofMap() {
        return MqlValues.ofMap(new BsonDocument());
    }

    public static <T extends MqlValue> MqlMap<T> ofMap(Bson bson) {
        Assertions.notNull("map", bson);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonDocument("$literal", bson.toBsonDocument(BsonDocument.class, (CodecRegistry)codecRegistry))));
    }

    public static MqlDocument of(Bson bson) {
        Assertions.notNull("document", bson);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonDocument("$literal", bson.toBsonDocument(BsonDocument.class, (CodecRegistry)codecRegistry))));
    }

    public static MqlValue ofNull() {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonNull())).assertImplementsAllExpressions();
    }

    static MqlNumber numberToMqlNumber(Number number) {
        Assertions.notNull("number", number);
        if (number instanceof Integer) {
            return MqlValues.of((Integer)number);
        }
        if (number instanceof Long) {
            return MqlValues.of((Long)number);
        }
        if (number instanceof Double) {
            return MqlValues.of((Double)number);
        }
        if (number instanceof Decimal128) {
            return MqlValues.of((Decimal128)number);
        }
        throw new IllegalArgumentException("Number must be one of: Integer, Long, Double, Decimal128");
    }
}

