/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.FacetSearchCollector;
import com.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.mongodb.client.model.search.SearchFacet;
import com.mongodb.client.model.search.SearchOperator;
import org.bson.Document;
import org.bson.conversions.Bson;

@Sealed
@Beta(value={Reason.CLIENT})
public interface SearchCollector
extends Bson {
    @Beta(value={Reason.CLIENT, Reason.SERVER})
    public static FacetSearchCollector facet(SearchOperator searchOperator, Iterable<? extends SearchFacet> iterable) {
        Assertions.notNull("operator", searchOperator);
        Assertions.notNull("facets", iterable);
        return new SearchConstructibleBsonElement("facet", (Bson)new Document("operator", searchOperator).append("facets", SearchFacet.combineToBson(iterable)));
    }

    public static SearchCollector of(Bson bson) {
        return new SearchConstructibleBsonElement(Assertions.notNull("collector", bson));
    }
}

