/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.AddSearchScoreExpression;
import com.mongodb.client.model.search.ConstantSearchScoreExpression;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.FuzzySearchOptions;
import com.mongodb.client.model.search.Log1pSearchScoreExpression;
import com.mongodb.client.model.search.LogSearchScoreExpression;
import com.mongodb.client.model.search.LowerBoundSearchCount;
import com.mongodb.client.model.search.MultiplySearchScoreExpression;
import com.mongodb.client.model.search.RelevanceSearchScoreExpression;
import com.mongodb.client.model.search.SearchCount;
import com.mongodb.client.model.search.SearchHighlight;
import com.mongodb.client.model.search.SearchOptions;
import com.mongodb.client.model.search.TotalSearchCount;
import com.mongodb.client.model.search.WildcardSearchPath;
import com.mongodb.internal.client.model.AbstractConstructibleBson;
import org.bson.BsonBoolean;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.Document;
import org.bson.conversions.Bson;

final class SearchConstructibleBson
extends AbstractConstructibleBson<SearchConstructibleBson>
implements RelevanceSearchScoreExpression,
ConstantSearchScoreExpression,
LogSearchScoreExpression,
Log1pSearchScoreExpression,
AddSearchScoreExpression,
MultiplySearchScoreExpression,
SearchOptions,
SearchHighlight,
TotalSearchCount,
LowerBoundSearchCount,
FuzzySearchOptions,
FieldSearchPath,
WildcardSearchPath {
    static final SearchConstructibleBson EMPTY_IMMUTABLE = new SearchConstructibleBson(AbstractConstructibleBson.EMPTY_IMMUTABLE);

    SearchConstructibleBson(Bson bson) {
        super(bson);
    }

    private SearchConstructibleBson(Bson bson, Document document) {
        super(bson, document);
    }

    @Override
    protected SearchConstructibleBson newSelf(Bson bson, Document document) {
        return new SearchConstructibleBson(bson, document);
    }

    @Override
    public SearchOptions index(String string) {
        return (SearchOptions)this.newAppended("index", new BsonString(Assertions.notNull("name", string)));
    }

    @Override
    public SearchOptions highlight(SearchHighlight searchHighlight) {
        return (SearchOptions)this.newAppended("highlight", Assertions.notNull("option", searchHighlight));
    }

    @Override
    public SearchOptions count(SearchCount searchCount) {
        return (SearchOptions)this.newAppended("count", Assertions.notNull("option", searchCount));
    }

    @Override
    public SearchOptions returnStoredSource(boolean bl) {
        return (SearchOptions)this.newAppended("returnStoredSource", new BsonBoolean(bl));
    }

    @Override
    public SearchConstructibleBson option(String string, Object object) {
        return (SearchConstructibleBson)this.newAppended(Assertions.notNull("name", string), Assertions.notNull("value", object));
    }

    @Override
    public SearchHighlight maxCharsToExamine(int n) {
        return (SearchHighlight)this.newAppended("maxCharsToExamine", new BsonInt32(n));
    }

    @Override
    public SearchHighlight maxNumPassages(int n) {
        return (SearchHighlight)this.newAppended("maxNumPassages", new BsonInt32(n));
    }

    @Override
    public LowerBoundSearchCount threshold(int n) {
        return (LowerBoundSearchCount)this.newAppended("threshold", new BsonInt32(n));
    }

    @Override
    public FuzzySearchOptions maxEdits(int n) {
        return (FuzzySearchOptions)this.newAppended("maxEdits", n);
    }

    @Override
    public FuzzySearchOptions prefixLength(int n) {
        return (FuzzySearchOptions)this.newAppended("prefixLength", n);
    }

    @Override
    public FuzzySearchOptions maxExpansions(int n) {
        return (FuzzySearchOptions)this.newAppended("maxExpansions", n);
    }

    @Override
    public FieldSearchPath multi(String string) {
        return (FieldSearchPath)this.newAppended("multi", new BsonString(Assertions.notNull("analyzerName", string)));
    }
}

