/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.AutocompleteSearchOperator;
import com.mongodb.client.model.search.ConstantSearchScore;
import com.mongodb.client.model.search.DateNearSearchOperator;
import com.mongodb.client.model.search.DateSearchFacet;
import com.mongodb.client.model.search.EqualsSearchOperator;
import com.mongodb.client.model.search.ExistsSearchOperator;
import com.mongodb.client.model.search.FacetSearchCollector;
import com.mongodb.client.model.search.FilterCompoundSearchOperator;
import com.mongodb.client.model.search.FunctionSearchScore;
import com.mongodb.client.model.search.FuzzySearchOptions;
import com.mongodb.client.model.search.GaussSearchScoreExpression;
import com.mongodb.client.model.search.GeoNearSearchOperator;
import com.mongodb.client.model.search.InSearchOperator;
import com.mongodb.client.model.search.MoreLikeThisSearchOperator;
import com.mongodb.client.model.search.MustCompoundSearchOperator;
import com.mongodb.client.model.search.MustNotCompoundSearchOperator;
import com.mongodb.client.model.search.NumberNearSearchOperator;
import com.mongodb.client.model.search.NumberSearchFacet;
import com.mongodb.client.model.search.PathBoostSearchScore;
import com.mongodb.client.model.search.PathSearchScoreExpression;
import com.mongodb.client.model.search.QueryStringSearchOperator;
import com.mongodb.client.model.search.RegexSearchOperator;
import com.mongodb.client.model.search.SearchOperator;
import com.mongodb.client.model.search.SearchScore;
import com.mongodb.client.model.search.ShouldCompoundSearchOperator;
import com.mongodb.client.model.search.StringSearchFacet;
import com.mongodb.client.model.search.TextSearchOperator;
import com.mongodb.client.model.search.ValueBoostSearchScore;
import com.mongodb.client.model.search.WildcardSearchOperator;
import com.mongodb.internal.client.model.AbstractConstructibleBsonElement;
import com.mongodb.internal.client.model.Util;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.BsonInt32;
import org.bson.conversions.Bson;

final class SearchConstructibleBsonElement
extends AbstractConstructibleBsonElement<SearchConstructibleBsonElement>
implements MustCompoundSearchOperator,
MustNotCompoundSearchOperator,
ShouldCompoundSearchOperator,
FilterCompoundSearchOperator,
ExistsSearchOperator,
TextSearchOperator,
AutocompleteSearchOperator,
NumberNearSearchOperator,
DateNearSearchOperator,
GeoNearSearchOperator,
EqualsSearchOperator,
InSearchOperator,
MoreLikeThisSearchOperator,
RegexSearchOperator,
QueryStringSearchOperator,
WildcardSearchOperator,
ValueBoostSearchScore,
PathBoostSearchScore,
ConstantSearchScore,
FunctionSearchScore,
GaussSearchScoreExpression,
PathSearchScoreExpression,
FacetSearchCollector,
StringSearchFacet,
NumberSearchFacet,
DateSearchFacet {
    SearchConstructibleBsonElement(String string) {
        super(string);
    }

    SearchConstructibleBsonElement(String string, Bson bson) {
        super(string, bson);
    }

    SearchConstructibleBsonElement(Bson bson) {
        super(bson);
    }

    private SearchConstructibleBsonElement(Bson bson, Bson bson2) {
        super(bson, bson2);
    }

    @Override
    protected SearchConstructibleBsonElement newSelf(Bson bson, Bson bson2) {
        return new SearchConstructibleBsonElement(bson, bson2);
    }

    @Override
    public StringSearchFacet numBuckets(int n) {
        return (StringSearchFacet)this.newWithAppendedValue("numBuckets", n);
    }

    @Override
    public SearchConstructibleBsonElement defaultBucket(String string) {
        return (SearchConstructibleBsonElement)this.newWithAppendedValue("default", Assertions.notNull("name", string));
    }

    @Override
    public SearchConstructibleBsonElement fuzzy() {
        return this.fuzzy(FuzzySearchOptions.fuzzySearchOptions());
    }

    @Override
    public SearchConstructibleBsonElement fuzzy(FuzzySearchOptions fuzzySearchOptions) {
        return (SearchConstructibleBsonElement)this.newWithMutatedValue(document -> {
            document.remove("synonyms");
            document.append("fuzzy", Assertions.notNull("options", fuzzySearchOptions));
        });
    }

    @Override
    public TextSearchOperator synonyms(String string) {
        return (TextSearchOperator)this.newWithMutatedValue(document -> {
            document.remove("fuzzy");
            document.append("synonyms", Assertions.notNull("name", string));
        });
    }

    @Override
    public AutocompleteSearchOperator anyTokenOrder() {
        return (AutocompleteSearchOperator)this.newWithAppendedValue("tokenOrder", "any");
    }

    @Override
    public AutocompleteSearchOperator sequentialTokenOrder() {
        return (AutocompleteSearchOperator)this.newWithAppendedValue("tokenOrder", "sequential");
    }

    @Override
    public MustCompoundSearchOperator must(Iterable<? extends SearchOperator> iterable) {
        return this.newCombined("must", iterable);
    }

    @Override
    public MustNotCompoundSearchOperator mustNot(Iterable<? extends SearchOperator> iterable) {
        return this.newCombined("mustNot", iterable);
    }

    @Override
    public ShouldCompoundSearchOperator should(Iterable<? extends SearchOperator> iterable) {
        return this.newCombined("should", iterable);
    }

    @Override
    public FilterCompoundSearchOperator filter(Iterable<? extends SearchOperator> iterable) {
        return this.newCombined("filter", iterable);
    }

    private SearchConstructibleBsonElement newCombined(String string, Iterable<? extends SearchOperator> iterable) {
        Assertions.notNull("clauses", iterable);
        Assertions.isTrueArgument("clauses must not be empty", Util.sizeAtLeast(iterable, 1));
        return (SearchConstructibleBsonElement)this.newWithMutatedValue(document -> {
            Iterable iterable2 = (Iterable)((Object)document.get((Object)string, Iterable.class));
            Iterable iterable3 = iterable2 == null ? iterable : (Iterable)Stream.concat(StreamSupport.stream(iterable2.spliterator(), false), StreamSupport.stream(iterable.spliterator(), false)).collect(Collectors.toList());
            document.append(string, iterable3);
        });
    }

    @Override
    public ShouldCompoundSearchOperator minimumShouldMatch(int n) {
        return (ShouldCompoundSearchOperator)this.newWithAppendedValue("minimumShouldMatch", new BsonInt32(n));
    }

    @Override
    public SearchConstructibleBsonElement score(SearchScore searchScore) {
        return (SearchConstructibleBsonElement)this.newWithAppendedValue("score", Assertions.notNull("modifier", searchScore));
    }

    @Override
    public SearchConstructibleBsonElement undefined(float f) {
        return (SearchConstructibleBsonElement)this.newWithAppendedValue("undefined", Float.valueOf(f));
    }

    @Override
    public GaussSearchScoreExpression offset(double d) {
        return (GaussSearchScoreExpression)this.newWithAppendedValue("offset", d);
    }

    @Override
    public GaussSearchScoreExpression decay(double d) {
        return (GaussSearchScoreExpression)this.newWithAppendedValue("decay", d);
    }
}

