/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.DateSearchFacet;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.NumberSearchFacet;
import com.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.mongodb.client.model.search.StringSearchFacet;
import com.mongodb.internal.client.model.Util;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@Sealed
@Beta(value={Reason.CLIENT, Reason.SERVER})
public interface SearchFacet
extends Bson {
    public static StringSearchFacet stringFacet(String string, FieldSearchPath fieldSearchPath) {
        return new SearchConstructibleBsonElement(Assertions.notNull("name", string), (Bson)new Document("type", "string").append("path", Assertions.notNull("path", fieldSearchPath).toValue()));
    }

    public static NumberSearchFacet numberFacet(String string, FieldSearchPath fieldSearchPath, Iterable<? extends Number> iterable) {
        Assertions.isTrueArgument("boundaries must contain at least 2 elements", Util.sizeAtLeast(iterable, 2));
        return new SearchConstructibleBsonElement(Assertions.notNull("name", string), (Bson)new Document("type", "number").append("path", Assertions.notNull("path", fieldSearchPath).toValue()).append("boundaries", Assertions.notNull("boundaries", iterable)));
    }

    public static DateSearchFacet dateFacet(String string, FieldSearchPath fieldSearchPath, Iterable<Instant> iterable) {
        Assertions.isTrueArgument("boundaries must contain at least 2 elements", Util.sizeAtLeast(iterable, 2));
        return new SearchConstructibleBsonElement(Assertions.notNull("name", string), (Bson)new Document("type", "date").append("path", Assertions.notNull("path", fieldSearchPath).toValue()).append("boundaries", Assertions.notNull("boundaries", iterable)));
    }

    public static SearchFacet of(Bson bson) {
        return new SearchConstructibleBsonElement(Assertions.notNull("facet", bson));
    }

    public static Bson combineToBson(final Iterable<? extends SearchFacet> iterable) {
        Assertions.notNull("facets", iterable);
        Assertions.isTrueArgument("facets must not be empty", Util.sizeAtLeast(iterable, 1));
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
                HashSet<String> hashSet = new HashSet<String>();
                BsonDocument bsonDocument = new BsonDocument();
                for (SearchFacet searchFacet : iterable) {
                    BsonDocument bsonDocument2 = searchFacet.toBsonDocument(clazz, codecRegistry);
                    Assertions.assertTrue(bsonDocument2.size() == 1);
                    Map.Entry<String, BsonValue> entry = bsonDocument2.entrySet().iterator().next();
                    String string = entry.getKey();
                    Assertions.isTrue(String.format("facet names must be unique. '%s' is used at least twice in %s", hashSet, iterable), hashSet.add(string));
                    bsonDocument.append(string, entry.getValue());
                }
                return bsonDocument;
            }

            public String toString() {
                return iterable.toString();
            }
        };
    }
}

