/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.SearchConstructibleBson;
import com.mongodb.client.model.search.SearchPath;
import com.mongodb.internal.Iterables;
import com.mongodb.internal.client.model.Util;
import java.util.Iterator;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

@Sealed
@Beta(value={Reason.CLIENT})
public interface SearchHighlight
extends Bson {
    public SearchHighlight maxCharsToExamine(int var1);

    public SearchHighlight maxNumPassages(int var1);

    public static SearchHighlight paths(SearchPath searchPath, SearchPath ... searchPathArray) {
        return SearchHighlight.paths(Iterables.concat(Assertions.notNull("path", searchPath), searchPathArray));
    }

    public static SearchHighlight paths(Iterable<? extends SearchPath> iterable) {
        Iterator<? extends SearchPath> iterator = Assertions.notNull("paths", iterable).iterator();
        Assertions.isTrueArgument("paths must not be empty", iterator.hasNext());
        return new SearchConstructibleBson(new BsonDocument("path", Util.combineToBsonValue(iterator, false)));
    }

    public static SearchHighlight of(Bson bson) {
        return new SearchConstructibleBson(Assertions.notNull("highlight", bson));
    }
}

