/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.model.search.AutocompleteSearchOperator;
import com.mongodb.client.model.search.CompoundSearchOperatorBase;
import com.mongodb.client.model.search.DateNearSearchOperator;
import com.mongodb.client.model.search.DateRangeConstructibleBsonElement;
import com.mongodb.client.model.search.DateRangeSearchOperatorBase;
import com.mongodb.client.model.search.EqualsSearchOperator;
import com.mongodb.client.model.search.ExistsSearchOperator;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.GeoNearSearchOperator;
import com.mongodb.client.model.search.InSearchOperator;
import com.mongodb.client.model.search.MoreLikeThisSearchOperator;
import com.mongodb.client.model.search.NumberNearSearchOperator;
import com.mongodb.client.model.search.NumberRangeConstructibleBsonElement;
import com.mongodb.client.model.search.NumberRangeSearchOperatorBase;
import com.mongodb.client.model.search.PhraseConstructibleBsonElement;
import com.mongodb.client.model.search.PhraseSearchOperator;
import com.mongodb.client.model.search.QueryStringSearchOperator;
import com.mongodb.client.model.search.RegexSearchOperator;
import com.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.mongodb.client.model.search.SearchPath;
import com.mongodb.client.model.search.SearchScore;
import com.mongodb.client.model.search.TextSearchOperator;
import com.mongodb.client.model.search.WildcardSearchOperator;
import com.mongodb.internal.Iterables;
import com.mongodb.internal.client.model.Util;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

@Sealed
@Beta(value={Reason.CLIENT})
public interface SearchOperator
extends Bson {
    public SearchOperator score(SearchScore var1);

    public static CompoundSearchOperatorBase compound() {
        return new SearchConstructibleBsonElement("compound");
    }

    public static ExistsSearchOperator exists(FieldSearchPath fieldSearchPath) {
        return new SearchConstructibleBsonElement("exists", (Bson)new Document("path", Assertions.notNull("path", fieldSearchPath).toValue()));
    }

    public static TextSearchOperator text(SearchPath searchPath, String string) {
        return SearchOperator.text(Collections.singleton(Assertions.notNull("path", searchPath)), Collections.singleton(Assertions.notNull("query", string)));
    }

    public static TextSearchOperator text(Iterable<? extends SearchPath> iterable, Iterable<String> iterable2) {
        Iterator<String> iterator = Assertions.notNull("queries", iterable2).iterator();
        Assertions.isTrueArgument("queries must not be empty", iterator.hasNext());
        String string = iterator.next();
        Iterator<? extends SearchPath> iterator2 = Assertions.notNull("paths", iterable).iterator();
        Assertions.isTrueArgument("paths must not be empty", iterator2.hasNext());
        return new SearchConstructibleBsonElement("text", (Bson)new Document("query", iterator.hasNext() ? iterable2 : string).append("path", Util.combineToBsonValue(iterator2, false)));
    }

    public static AutocompleteSearchOperator autocomplete(FieldSearchPath fieldSearchPath, String string, String ... stringArray) {
        return SearchOperator.autocomplete(fieldSearchPath, Iterables.concat(Assertions.notNull("query", string), stringArray));
    }

    public static AutocompleteSearchOperator autocomplete(FieldSearchPath fieldSearchPath, Iterable<String> iterable) {
        Iterator<String> iterator = Assertions.notNull("queries", iterable).iterator();
        Assertions.isTrueArgument("queries must not be empty", iterator.hasNext());
        String string = iterator.next();
        return new SearchConstructibleBsonElement("autocomplete", (Bson)new Document("query", iterator.hasNext() ? iterable : string).append("path", Assertions.notNull("path", fieldSearchPath).toValue()));
    }

    public static NumberRangeSearchOperatorBase numberRange(FieldSearchPath fieldSearchPath, FieldSearchPath ... fieldSearchPathArray) {
        return SearchOperator.numberRange(Iterables.concat(Assertions.notNull("path", fieldSearchPath), fieldSearchPathArray));
    }

    public static NumberRangeSearchOperatorBase numberRange(Iterable<? extends FieldSearchPath> iterable) {
        Iterator<? extends FieldSearchPath> iterator = Assertions.notNull("paths", iterable).iterator();
        Assertions.isTrueArgument("paths must not be empty", iterator.hasNext());
        return new NumberRangeConstructibleBsonElement("range", (Bson)new Document("path", Util.combineToBsonValue(iterator, true)));
    }

    public static DateRangeSearchOperatorBase dateRange(FieldSearchPath fieldSearchPath, FieldSearchPath ... fieldSearchPathArray) {
        return SearchOperator.dateRange(Iterables.concat(Assertions.notNull("path", fieldSearchPath), fieldSearchPathArray));
    }

    public static DateRangeSearchOperatorBase dateRange(Iterable<? extends FieldSearchPath> iterable) {
        Iterator<? extends FieldSearchPath> iterator = Assertions.notNull("paths", iterable).iterator();
        Assertions.isTrueArgument("paths must not be empty", iterator.hasNext());
        return new DateRangeConstructibleBsonElement("range", (Bson)new Document("path", Util.combineToBsonValue(iterator, true)));
    }

    public static NumberNearSearchOperator near(Number number, Number number2, FieldSearchPath fieldSearchPath, FieldSearchPath ... fieldSearchPathArray) {
        return SearchOperator.near(number, number2, Iterables.concat(Assertions.notNull("path", fieldSearchPath), fieldSearchPathArray));
    }

    public static NumberNearSearchOperator near(Number number, Number number2, Iterable<? extends FieldSearchPath> iterable) {
        Iterator<? extends FieldSearchPath> iterator = Assertions.notNull("paths", iterable).iterator();
        Assertions.isTrueArgument("paths must not be empty", iterator.hasNext());
        return new SearchConstructibleBsonElement("near", (Bson)new Document("origin", Assertions.notNull("origin", number)).append("path", Util.combineToBsonValue(iterator, true)).append("pivot", Assertions.notNull("pivot", number2)));
    }

    public static DateNearSearchOperator near(Instant instant, Duration duration, FieldSearchPath fieldSearchPath, FieldSearchPath ... fieldSearchPathArray) {
        return SearchOperator.near(instant, duration, Iterables.concat(Assertions.notNull("path", fieldSearchPath), fieldSearchPathArray));
    }

    public static DateNearSearchOperator near(Instant instant, Duration duration, Iterable<? extends FieldSearchPath> iterable) {
        Iterator<? extends FieldSearchPath> iterator = Assertions.notNull("paths", iterable).iterator();
        Assertions.isTrueArgument("paths must not be empty", iterator.hasNext());
        Assertions.notNull("pivot", duration);
        return new SearchConstructibleBsonElement("near", (Bson)new Document("origin", Assertions.notNull("origin", instant)).append("path", Util.combineToBsonValue(iterator, true)).append("pivot", duration.toMillis()));
    }

    public static GeoNearSearchOperator near(Point point, Number number, FieldSearchPath fieldSearchPath, FieldSearchPath ... fieldSearchPathArray) {
        return SearchOperator.near(point, number, Iterables.concat(Assertions.notNull("path", fieldSearchPath), fieldSearchPathArray));
    }

    public static GeoNearSearchOperator near(Point point, Number number, Iterable<? extends FieldSearchPath> iterable) {
        Iterator<? extends FieldSearchPath> iterator = Assertions.notNull("paths", iterable).iterator();
        Assertions.isTrueArgument("paths must not be empty", iterator.hasNext());
        return new SearchConstructibleBsonElement("near", (Bson)new Document("origin", Assertions.notNull("origin", point)).append("path", Util.combineToBsonValue(iterator, true)).append("pivot", Assertions.notNull("pivot", number)));
    }

    public static InSearchOperator in(FieldSearchPath fieldSearchPath, boolean bl, boolean ... blArray) {
        Assertions.notNull("values", blArray);
        BsonArray bsonArray = new BsonArray();
        bsonArray.add(new BsonBoolean(bl));
        for (boolean bl2 : blArray) {
            bsonArray.add(new BsonBoolean(bl2));
        }
        return SearchOperator.in(Assertions.notNull("path", fieldSearchPath), bsonArray);
    }

    public static InSearchOperator in(FieldSearchPath fieldSearchPath, ObjectId objectId, ObjectId ... objectIdArray) {
        return SearchOperator.in(Assertions.notNull("path", fieldSearchPath), Iterables.concat(Assertions.notNull("value", objectId), objectIdArray));
    }

    public static InSearchOperator in(FieldSearchPath fieldSearchPath, Number number, Number ... numberArray) {
        return SearchOperator.in(Assertions.notNull("path", fieldSearchPath), Iterables.concat(Assertions.notNull("value", number), numberArray));
    }

    public static InSearchOperator in(FieldSearchPath fieldSearchPath, Instant instant, Instant ... instantArray) {
        return SearchOperator.in(Assertions.notNull("path", fieldSearchPath), Iterables.concat(Assertions.notNull("value", instant), instantArray));
    }

    public static InSearchOperator in(FieldSearchPath fieldSearchPath, UUID uUID, UUID ... uUIDArray) {
        return SearchOperator.in(Assertions.notNull("path", fieldSearchPath), Iterables.concat(Assertions.notNull("value", uUID), uUIDArray));
    }

    public static InSearchOperator in(FieldSearchPath fieldSearchPath, String string, String ... stringArray) {
        return SearchOperator.in(Assertions.notNull("path", fieldSearchPath), Iterables.concat(Assertions.notNull("value", string), stringArray));
    }

    public static <T> InSearchOperator in(FieldSearchPath fieldSearchPath, Iterable<? extends T> iterable) {
        Assertions.notNull("path", fieldSearchPath);
        Iterator<T> iterator = Assertions.notNull("values", iterable).iterator();
        Assertions.isTrueArgument("values must not be empty", iterator.hasNext());
        T t = iterator.next();
        boolean bl = iterator.hasNext();
        return new SearchConstructibleBsonElement("in", (Bson)new Document().append("path", fieldSearchPath.toValue()).append("value", bl ? iterable : t));
    }

    public static EqualsSearchOperator equals(FieldSearchPath fieldSearchPath, boolean bl) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", fieldSearchPath).toValue()).append("value", bl));
    }

    public static EqualsSearchOperator equals(FieldSearchPath fieldSearchPath, ObjectId objectId) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", fieldSearchPath).toValue()).append("value", Assertions.notNull("value", objectId)));
    }

    public static EqualsSearchOperator equals(FieldSearchPath fieldSearchPath, Number number) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", fieldSearchPath).toValue()).append("value", Assertions.notNull("value", number)));
    }

    public static EqualsSearchOperator equals(FieldSearchPath fieldSearchPath, Instant instant) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", fieldSearchPath).toValue()).append("value", Assertions.notNull("value", instant)));
    }

    public static EqualsSearchOperator equals(FieldSearchPath fieldSearchPath, String string) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", fieldSearchPath).toValue()).append("value", Assertions.notNull("value", string)));
    }

    public static EqualsSearchOperator equals(FieldSearchPath fieldSearchPath, UUID uUID) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", fieldSearchPath).toValue()).append("value", Assertions.notNull("value", new BsonBinary(uUID))));
    }

    public static EqualsSearchOperator equalsNull(FieldSearchPath fieldSearchPath) {
        return new SearchConstructibleBsonElement("equals", (Bson)new Document("path", Assertions.notNull("path", fieldSearchPath).toValue()).append("value", BsonNull.VALUE));
    }

    public static MoreLikeThisSearchOperator moreLikeThis(BsonDocument bsonDocument) {
        return SearchOperator.moreLikeThis(Collections.singleton(Assertions.notNull("like", bsonDocument)));
    }

    public static MoreLikeThisSearchOperator moreLikeThis(Iterable<BsonDocument> iterable) {
        Iterator<BsonDocument> iterator = Assertions.notNull("likes", iterable).iterator();
        Assertions.isTrueArgument("likes must not be empty", iterator.hasNext());
        BsonDocument bsonDocument = iterator.next();
        return new SearchConstructibleBsonElement("moreLikeThis", (Bson)new Document("like", iterator.hasNext() ? iterable : bsonDocument));
    }

    public static QueryStringSearchOperator queryString(FieldSearchPath fieldSearchPath, String string) {
        Assertions.isTrueArgument("path must not be empty", fieldSearchPath != null);
        Assertions.isTrueArgument("query must not be empty", string != null);
        return new SearchConstructibleBsonElement("queryString", (Bson)new Document("defaultPath", fieldSearchPath.toBsonValue()).append("query", string));
    }

    public static PhraseSearchOperator phrase(SearchPath searchPath, String string) {
        return SearchOperator.phrase(Collections.singleton(Assertions.notNull("path", searchPath)), Collections.singleton(Assertions.notNull("query", string)));
    }

    public static PhraseSearchOperator phrase(Iterable<? extends SearchPath> iterable, Iterable<String> iterable2) {
        Iterator<? extends SearchPath> iterator = Assertions.notNull("paths", iterable).iterator();
        Assertions.isTrueArgument("paths must not be empty", iterator.hasNext());
        Iterator<String> iterator2 = Assertions.notNull("queries", iterable2).iterator();
        Assertions.isTrueArgument("queries must not be empty", iterator2.hasNext());
        String string = iterator2.next();
        return new PhraseConstructibleBsonElement("phrase", (Bson)new Document("path", Util.combineToBsonValue(iterator, false)).append("query", iterator2.hasNext() ? iterable2 : string));
    }

    public static WildcardSearchOperator wildcard(SearchPath searchPath, String string) {
        return SearchOperator.wildcard(Collections.singleton(Assertions.notNull("query", string)), Collections.singleton(Assertions.notNull("path", searchPath)));
    }

    public static WildcardSearchOperator wildcard(Iterable<String> iterable, Iterable<? extends SearchPath> iterable2) {
        Iterator<String> iterator = Assertions.notNull("queries", iterable).iterator();
        Assertions.isTrueArgument("queries must not be empty", iterator.hasNext());
        String string = iterator.next();
        Iterator<? extends SearchPath> iterator2 = Assertions.notNull("paths", iterable2).iterator();
        Assertions.isTrueArgument("paths must not be empty", iterator2.hasNext());
        return new SearchConstructibleBsonElement("wildcard", (Bson)new Document("query", iterator.hasNext() ? iterable : string).append("path", Util.combineToBsonValue(iterator2, false)));
    }

    public static RegexSearchOperator regex(SearchPath searchPath, String string) {
        return SearchOperator.regex(Collections.singleton(Assertions.notNull("path", searchPath)), Collections.singleton(Assertions.notNull("query", string)));
    }

    public static RegexSearchOperator regex(Iterable<? extends SearchPath> iterable, Iterable<String> iterable2) {
        Iterator<? extends SearchPath> iterator = Assertions.notNull("paths", iterable).iterator();
        Assertions.isTrueArgument("paths must not be empty", iterator.hasNext());
        Iterator<String> iterator2 = Assertions.notNull("queries", iterable2).iterator();
        Assertions.isTrueArgument("queries must not be empty", iterator2.hasNext());
        String string = iterator2.next();
        return new SearchConstructibleBsonElement("regex", (Bson)new Document("path", Util.combineToBsonValue(iterator, false)).append("query", iterator2.hasNext() ? iterable2 : string));
    }

    public static SearchOperator of(Bson bson) {
        return new SearchConstructibleBsonElement(Assertions.notNull("operator", bson));
    }
}

