/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.SearchConstructibleBson;
import com.mongodb.client.model.search.WildcardSearchPath;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

@Sealed
@Beta(value={Reason.CLIENT})
public interface SearchPath
extends Bson {
    public static FieldSearchPath fieldPath(String string) {
        Assertions.notNull("path", string);
        Assertions.isTrueArgument("path must not contain '*'", !string.contains("*"));
        return new SearchConstructibleBson(new BsonDocument("value", new BsonString(string)));
    }

    public static WildcardSearchPath wildcardPath(String string) {
        Assertions.notNull("wildcardPath", string);
        Assertions.isTrueArgument("wildcardPath must contain '*'", string.contains("*"));
        Assertions.isTrueArgument("wildcardPath must not contain '**'", !string.contains("**"));
        return new SearchConstructibleBson(new BsonDocument("wildcard", new BsonString(string)));
    }

    default public BsonValue toBsonValue() {
        BsonDocument bsonDocument = this.toBsonDocument();
        if (bsonDocument.size() > 1) {
            return bsonDocument;
        }
        BsonString bsonString = bsonDocument.getString("value", null);
        if (bsonString != null) {
            return bsonString;
        }
        return bsonDocument;
    }
}

