/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.ConstantSearchScore;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.FunctionSearchScore;
import com.mongodb.client.model.search.PathBoostSearchScore;
import com.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.mongodb.client.model.search.SearchScoreExpression;
import com.mongodb.client.model.search.ValueBoostSearchScore;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.Document;
import org.bson.conversions.Bson;

@Sealed
@Beta(value={Reason.CLIENT})
public interface SearchScore
extends Bson {
    public static ValueBoostSearchScore boost(float f) {
        return new SearchConstructibleBsonElement("boost", (Bson)new BsonDocument("value", new BsonDouble(f)));
    }

    public static PathBoostSearchScore boost(FieldSearchPath fieldSearchPath) {
        return new SearchConstructibleBsonElement("boost", (Bson)new Document("path", Assertions.notNull("value", fieldSearchPath).toValue()));
    }

    public static ConstantSearchScore constant(float f) {
        return new SearchConstructibleBsonElement("constant", (Bson)new BsonDocument("value", new BsonDouble(f)));
    }

    public static FunctionSearchScore function(SearchScoreExpression searchScoreExpression) {
        return new SearchConstructibleBsonElement("function", (Bson)Assertions.notNull("expression", searchScoreExpression));
    }

    public static SearchScore of(Bson bson) {
        return new SearchConstructibleBsonElement(Assertions.notNull("score", bson));
    }
}

