/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.AddSearchScoreExpression;
import com.mongodb.client.model.search.ConstantSearchScoreExpression;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.GaussSearchScoreExpression;
import com.mongodb.client.model.search.Log1pSearchScoreExpression;
import com.mongodb.client.model.search.LogSearchScoreExpression;
import com.mongodb.client.model.search.MultiplySearchScoreExpression;
import com.mongodb.client.model.search.PathSearchScoreExpression;
import com.mongodb.client.model.search.RelevanceSearchScoreExpression;
import com.mongodb.client.model.search.SearchConstructibleBson;
import com.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.mongodb.internal.client.model.Util;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonString;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@Sealed
@Beta(value={Reason.CLIENT})
public interface SearchScoreExpression
extends Bson {
    public static RelevanceSearchScoreExpression relevanceExpression() {
        return new SearchConstructibleBson(new BsonDocument("score", new BsonString("relevance")));
    }

    public static PathSearchScoreExpression pathExpression(FieldSearchPath fieldSearchPath) {
        return new SearchConstructibleBsonElement("path", (Bson)new Document("value", Assertions.notNull("path", fieldSearchPath).toValue()));
    }

    public static ConstantSearchScoreExpression constantExpression(float f) {
        return new SearchConstructibleBson(new BsonDocument("constant", new BsonDouble(f)));
    }

    public static GaussSearchScoreExpression gaussExpression(final double d, final PathSearchScoreExpression pathSearchScoreExpression, final double d2) {
        Assertions.notNull("path", pathSearchScoreExpression);
        Bson bson = new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> clazz, CodecRegistry codecRegistry) {
                BsonDocument bsonDocument = pathSearchScoreExpression.toBsonDocument(clazz, codecRegistry);
                Assertions.assertTrue(bsonDocument.size() == 1);
                return new BsonDocument("origin", new BsonDouble(d)).append("path", bsonDocument.values().iterator().next()).append("scale", new BsonDouble(d2));
            }

            public String toString() {
                return new Document("origin", d).append("path", pathSearchScoreExpression).append("scale", d2).toString();
            }
        };
        return new SearchConstructibleBsonElement("gauss", bson);
    }

    public static LogSearchScoreExpression logExpression(SearchScoreExpression searchScoreExpression) {
        return new SearchConstructibleBson(new Document("log", Assertions.notNull("expression", searchScoreExpression)));
    }

    public static Log1pSearchScoreExpression log1pExpression(SearchScoreExpression searchScoreExpression) {
        return new SearchConstructibleBson(new Document("log1p", Assertions.notNull("expression", searchScoreExpression)));
    }

    public static AddSearchScoreExpression addExpression(Iterable<? extends SearchScoreExpression> iterable) {
        Assertions.notNull("expressions", iterable);
        Assertions.isTrueArgument("expressions must contain at least 2 elements", Util.sizeAtLeast(iterable, 2));
        return new SearchConstructibleBson(new Document("add", iterable));
    }

    public static MultiplySearchScoreExpression multiplyExpression(Iterable<? extends SearchScoreExpression> iterable) {
        Assertions.notNull("expressions", iterable);
        Assertions.isTrueArgument("expressions must contain at least 2 elements", Util.sizeAtLeast(iterable, 2));
        return new SearchConstructibleBson(new Document("multiply", iterable));
    }

    public static SearchScoreExpression of(Bson bson) {
        return new SearchConstructibleBson(Assertions.notNull("expression", bson));
    }
}

