/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.result;

public abstract class DeleteResult {
    public abstract boolean wasAcknowledged();

    public abstract long getDeletedCount();

    public static DeleteResult acknowledged(long l) {
        return new AcknowledgedDeleteResult(l);
    }

    public static DeleteResult unacknowledged() {
        return new UnacknowledgedDeleteResult();
    }

    private static class AcknowledgedDeleteResult
    extends DeleteResult {
        private final long deletedCount;

        AcknowledgedDeleteResult(long l) {
            this.deletedCount = l;
        }

        @Override
        public boolean wasAcknowledged() {
            return true;
        }

        @Override
        public long getDeletedCount() {
            return this.deletedCount;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AcknowledgedDeleteResult acknowledgedDeleteResult = (AcknowledgedDeleteResult)object;
            return this.deletedCount == acknowledgedDeleteResult.deletedCount;
        }

        public int hashCode() {
            return (int)(this.deletedCount ^ this.deletedCount >>> 32);
        }

        public String toString() {
            return "AcknowledgedDeleteResult{deletedCount=" + this.deletedCount + '}';
        }
    }

    private static class UnacknowledgedDeleteResult
    extends DeleteResult {
        private UnacknowledgedDeleteResult() {
        }

        @Override
        public boolean wasAcknowledged() {
            return false;
        }

        @Override
        public long getDeletedCount() {
            throw new UnsupportedOperationException("Cannot get information about an unacknowledged delete");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object != null && this.getClass() == object.getClass();
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "UnacknowledgedDeleteResult{}";
        }
    }
}

