/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.result;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonValue;

public abstract class InsertManyResult {
    public abstract boolean wasAcknowledged();

    public abstract Map<Integer, BsonValue> getInsertedIds();

    public static InsertManyResult acknowledged(Map<Integer, BsonValue> map) {
        return new AcknowledgedInsertManyResult(map);
    }

    public static InsertManyResult unacknowledged() {
        return new UnacknowledgedInsertManyResult();
    }

    private static class AcknowledgedInsertManyResult
    extends InsertManyResult {
        private final Map<Integer, BsonValue> insertedIds;

        AcknowledgedInsertManyResult(Map<Integer, BsonValue> map) {
            this.insertedIds = Collections.unmodifiableMap(new HashMap<Integer, BsonValue>(map));
        }

        @Override
        public boolean wasAcknowledged() {
            return true;
        }

        @Override
        public Map<Integer, BsonValue> getInsertedIds() {
            return this.insertedIds;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AcknowledgedInsertManyResult acknowledgedInsertManyResult = (AcknowledgedInsertManyResult)object;
            return Objects.equals(this.insertedIds, acknowledgedInsertManyResult.insertedIds);
        }

        public int hashCode() {
            return Objects.hash(this.insertedIds);
        }

        public String toString() {
            return "AcknowledgedInsertManyResult{insertedIds=" + this.insertedIds + '}';
        }
    }

    private static class UnacknowledgedInsertManyResult
    extends InsertManyResult {
        private UnacknowledgedInsertManyResult() {
        }

        @Override
        public boolean wasAcknowledged() {
            return false;
        }

        @Override
        public Map<Integer, BsonValue> getInsertedIds() {
            throw new UnsupportedOperationException("Cannot get information about an unacknowledged insert many");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object != null && this.getClass() == object.getClass();
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "UnacknowledgedInsertManyResult{}";
        }
    }
}

